<?php if ($partial !== false) : ?>
  <?php include_partial($partial, $this->getAttributes()); ?>
<?php else : ?>

  <?php include_partial('frontendManagement/modal_begin', $this->getAttributes()); ?>
  <?php
  echo jq_form_remote_tag(array(
    'url' => $sf_data->getRaw('formUrl'),
    'loading' => 'ManageForm.startIndicator(ManageForm.getPopupContent());',
    'success' => 'ManageForm.onSuccess(data);',
    'statusCode' => '301: function(xhr){window.location.assign(xhr.responseText)}',
  ), array(
      'class' => 'form-horizontal',
  ));
  ?>
        <div class="row">
        <div class="col-md-12">
            <div class="alert alert-info">
                <?= __t('Możesz zmienić kolejność pozycji w menu używając metody przeciągnij i upuść (Drag&Drop). Złap pozycję i upuść w wybranym miejscu. Liczby w prawym górnym rogu reprezentują kolejność pozycji przed modyfikacją. Pamiętaj o zapisaniu kolejności.', array(), 'fm'); ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <ul class="list-order">
                <?php foreach ($list as $order => $element) : ?>
                    <li>
                        <span class="btn-block btn btn-lg"><?= $element; ?></span>
                        <input type="hidden" name="order[<?= ++$order; ?>]" value="<?= $element->getId() ?>"/>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>

    <div class="form-group">
        <div class="col-md-4">
            <button type="button" class="btn pull-left" data-dismiss="modal" aria-hidden="true"><?= __('Anuluj'); ?></button>
        </div>
        <div class="col-md-4 col-md-offset-4">
            <button type="submit" onclick="updateCKE();" class="btn btn-primary pull-right"><i class="icon-ok"></i> <?= __('Zapisz kolejność'); ?></button>
        </div>
    </div>
    </form>

  <script type="text/javascript">
    $(document).ready(function() {
      $(ManageForm.getPopup() + ' .list-order').sortable();
    });
  </script>

  <?php include_partial('frontendManagement/modal_end', $this->getAttributes()); ?>

<?php endif; ?>