<?php if ($partial !== false) : ?>
  <?php include_partial($partial, $this->getAttributes()); ?>
<?php else : ?>

  <?php include_partial('frontendManagement/modal_begin', $this->getAttributes()); ?>

  <div class="modal-body <?= $model; ?>">
    <table class="table table-bordered table-hover">
      <thead>
        <tr>
          <th><?= __t('#', array(), 'fm'); ?></th>
          <th><?= __t('Nazwa obiektu', array(), 'fm'); ?></th>
          <th><?= __t('Operacje', array(), 'fm'); ?></th>
        </tr>
      </thead>
      <tbody>
        <?php if ($pager->getNbResults() > 0) : ?>
          <?php foreach ($pager->getResults() as $order => $element) : ?>
            <tr>
              <td><?= $element->getId(); ?></td>
              <td><?= artStringConverter::addOnly3Dotes($element, 100); ?></td>
              <td><a class="btn btn-primary btn-sm" onclick="ManageForm.startIndicator(ManageForm.getPopupContent()); ManageForm.artConfigurationEdit(this,'<?= $element->getId(); ?>');" href="javascript:void(0);"><i class="megaicon1-pencil"></i> <?=__('Edytuj');?></a></td>
            </tr>
          <?php endforeach; ?>
        <?php else : ?>
          <tr>
            <td colspan="3"><?= __t('Brak wyników', array(), 'fm'); ?></td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>

  <?php if ($pager->haveToPaginate()) : ?>
    <div class="row">
      <ul class="pagination pagination-colory">
        <?php foreach ($pager->getLinks() as $page) : ?>
          <li class="<?= ($page == $pager->getPage() ? 'active' : ''); ?>"><a href="#" onclick="ManageForm.startIndicator(ManageForm.getPopupContent()); ManageForm.artConfigurationList(this, '<?= $page; ?>');"><?= $page; ?></a></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>
  </div>

  <div class="modal-footer">
  </div>

  <?php include_partial('frontendManagement/modal_end', $this->getAttributes()); ?>

<?php endif; ?>