<?php

/**
 * 
 */
class artCmsPluginGalleriesActions extends artCmsPluginActions {

  /*
   * Akcja wyświetlająca artykuł.
   *
   * @params sfWebRequest $request;
   * - slug , slug artykułu.
   */
  public function executeShow(sfWebRequest $request) {

    $this->article = $this->getRequest()->getParameter('object', NULL);
    
    if(empty($this->article)){
      $this->forward404("Brak obiektu artykułu");
    }

    if (sfConfig::get('app_art_cms_plugin_article_slot', FALSE))
      $this->getResponse()->setSlot("article", $this->article);

    $this->checkArticlePermissions($this->article);

    ArtConfiguration::setArticleMetaTags($this->article, $this->getResponse());

    $view = $this->article->getLayout()->getView();
    
    if ($view  === "FullScreen")
      $this->setLayout("layout_FullScreen");
    else
      $this->setLayout("layout_Gallery");
    
    return $view;
  }

}
