<?php $articlePhotos = $article->getArticlePhotoesOrdered(); ?>

<?php if ($articlePhotos->count() > 0) : ?>
  <ul class="rslides">
    <?php foreach ($articlePhotos as $photo) : ?>
      <li>
        <?= image_tag(GalleryManagement::getBigImagePath($article->getId(), 'ArticlePhoto', $photo)); ?>
      </li>
    <?php endforeach; ?>
  </ul>
  <?= inline_drag_drop(); ?>
  <?= inline_gallery($article); ?>

  <script type="text/javascript">
    $(function() {
      $(".rslides").responsiveSlides({
        auto: true, // Boolean: Animate automatically, true or false
        speed: 500, // Integer: Speed of the transition, in milliseconds
        timeout: 4000, // Integer: Time between slide transitions, in milliseconds
        pager: true, // Boolean: Show pager, true or false
        nav: true, // Boolean: Show navigation, true or false
        random: false, // Boolean: Randomize the order of the slides, true or false
        pause: false, // Boolean: Pause on hover, true or false
        pauseControls: true, // Boolean: Pause when hovering controls, true or false
        prevText: "<i class=\"glyphicon glyphicon-chevron-left\"></i>", // String: Text for the "previous" button
        nextText: "<i class=\"glyphicon glyphicon-chevron-right\"></i>", // String: Text for the "next" button
        maxwidth: "", // Integer: Max-width of the slideshow, in pixels
        navContainer: "ul.rslides", // Selector: Where controls should be appended to, default is after the 'ul'
        manualControls: "", // Selector: Declare custom pager navigation
        namespace: "rslides", // String: Change the default namespace used
        before: function() {
        }, // Function: Before callback
        after: function() {
        }     // Function: After callback
      });
    });

  </script>
<?php endif; ?>

<?= inline_drag_drop(); ?>
<?= inline_gallery($article); ?>
