<div class="pre_footer">
  <div class="container">
    <aside id="footer_bar" class="row">
      <div class="span3">
        <div class="sidepanel widget_posts">
          <div class="bg_title"><h3 class="sidebar_header"><?= __("Ostatnie posty") ?></h3></div>
          <ul class="recent_posts">
            <?php foreach ($articles as $key => $article): ?>
              <li>
                <div class="recent_posts_img">
                  <a href="<?= $article->getUrl(); ?>">
                    <?php if ($article->getFirstSmallPhoto() != '' && is_file($article->getFirstSmallPhoto(true))): ?>
                      <img src="<?= $article->getFirstSmallPhoto() ?>" alt="" width="88" height="88"/>
                    <?php else: ?>
                      <img src="<?= url_for('@placehold') . '?88-88-CCCCCC-969696&text=' . $article->getEscapedTitle(); ?>" alt="" width="88" height="88"/>
                    <?php endif; ?>
                  </a>
                </div>

                <div class="recent_posts_content">
                  <a href="<?= $article->getUrl(); ?>" class="post_title"><?= $article->getEscapedTitle(); ?></a>
                  <?= new FmActionBar($article, array('whitelist' => array('article_edit'))); ?>
                  <?= artStringConverter::addOnly3Dotes($article->getEscapedShortDescription(), 100); ?>
                </div>
                <div class="clear"></div>
              </li>
            <?php endforeach; ?>

            <?php if (count($articles) == 0): ?>
              <li>
                <div class="recent_posts_img">
                  <img src="<?= url_for('@image') . '?150-150-CCCCCC-969696&text=?'; ?>" alt="" width="88" height="88"/>
                </div>

                <div class="recent_posts_content">
                  <a href="#" class="post_title"><?= "Brak posŧów w blogu..."; ?></a>
                </div>
                <div class="clear"></div>
              </li>
            <?php endif; ?>
          </ul>
        </div><!-- .sidepanel -->
      </div>

      <div id="newsletter">
        <?= include_module_action('default', 'newsletter'); ?>
      </div>

      <div class="span3">
        <div class="sidepanel widget_mailchimpsf_widget">
          <div class="bg_title">
            <h3 class="sidebar_header" <?= inline_attr($aboutArticle, 'title'); ?>>
              <?= $aboutArticle->getEscapedTitle(); ?>
            </h3>
            <?= new FmActionBar($aboutArticle, array('whitelist' => array('article_edit'))); ?>
          </div>
          <div <?= inline_attr($aboutArticle, 'description'); ?>>
            <?php $aboutArticle->getShortDescriptionHtml(); ?>
          </div>

          <?php inline_edit($aboutArticle) ?>
        </div><!-- .sidepanel -->
      </div>               
      <div class="span3">
        <div class="sidepanel widget_flickr">
          <div class="bg_title"><h3 class="sidebar_header"><?= __("Ostatnio dodane"); ?></h3></div>
          <div class="flickr_widget_wrapper">
            <?php foreach ($photoes as $key => $photo): ?>
              <?php if (file_exists(GalleryManagement::getSmallImageAbsolutePath($photo->getArticleId(), 'ArticlePhoto', $photo))): ?>
                <div id="flickr_badge_image1<?= $key ?>" class="flickr_badge_image">
                  <a href="<?= GalleryManagement::getBigImagePath($photo->getArticleId(), 'ArticlePhoto', $photo) ?>"
                     rel="<?= __('galeria'); ?>[2]" class="prettyPhoto" >

                    <img width="75" height="75" title="" alt="" 
                         src="<?= GalleryManagement::getSmallImagePath($photo->getArticleId(), 'ArticlePhoto', $photo) ?>">
                    <div class="flickr_fadder"></div>
                  </a>
                </div>
              <?php endif; ?>
            <?php endforeach; ?>
          </div>

        </div><!-- .sidepanel -->                        
      </div>
  <!--</div>-->
</aside>
  </div>
</div><!-- .pre_footer -->