<?php

require_once dirname(__FILE__) . '/../lib/pa_articleGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/pa_articleGeneratorHelper.class.php';

/**
 * pa_article actions.
 *
 */
class Pluginpa_articleActions extends autoPa_articleActions
{

  public function executeManageGallery(sfWebRequest $request)
  {
    $this->redirect('@pa_article_edit?id=' . $request->getParameter('id') . '&open_tab=GalleryTab');
  }
  
  public function getTabsFormGalleryTab()
  {
    $this->getRequest()->setParameter('model', 'ArticlePhoto');
    
    $this->forward('pa_gallery', 'index');
  }

  public function getTabsFormFilesTab()
  {
    $this->getRequest()->setParameter('model', 'ArticleFile');
    
    $this->forward('pa_file', 'index');
  }
  
  public function setForeignKeysValues(sfWebRequest $request)
  {
    $values['id'] = $request->getParameter('id');

    return $values;
  }
  
  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->dispatcher->notify(new sfEvent($this, 'admin.delete_object', array('object' => $this->getRoute()->getObject())));
    $object = $this->getRoute()->getObject();
    
    if ($object->canBeDeleted() && $object->delete())
      $this->getUser()->setFlash('notice', 'The item was deleted successfully.');

    $this->redirect('@pa_article' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
  }
}
