<?php

require_once dirname(__FILE__) . '/../lib/pa_categoryGeneratorConfiguration.class.php';
require_once dirname(__FILE__) . '/../lib/pa_categoryGeneratorHelper.class.php';

/**
 * pa_category actions.
 *
 * @package    testmcs
 * @subpackage pa_category
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class Pluginpa_categoryActions extends autoPa_categoryActions
{

  public function getTabsFormSetCategoryOrderTab()
  {
    $this->forward('pa_category', 'setOrder');
  }

  public function setForeignKeysValues(sfWebRequest $request)
  {
    $values['id'] = $request->getParameter('id');

    return $values;
  }

  public function executeSetOrderFromList(sfWebRequest $request)
  {
    $this->redirect('@pa_category_edit?id=' . $request->getParameter('id') . '&open_tab=SetCategoryOrderTab');
  }

  public function executeSetOrder(sfWebRequest $request)
  {
    $categoryId = $request->getParameter('id');

    $this->articlesAndSubcategories = Doctrine::getTable('ArticleCategory')->getArticlesAndSubcategories($categoryId);
    
    $subcategoriesArray = array();
    $subcategoryDeleted = false;
    
    foreach ($this->articlesAndSubcategories as $object)
    {
      if (!is_null($object->getSubcategoryId()))
      {
        if (!isset($subcategoriesArray[$object->getSubcategoryId()]))
          $subcategoriesArray[$object->getSubcategoryId()] = $object;
        else
        {
          $subcategoryDeleted = true;
          $object->delete();
        }
      }
    }
    
    if ($subcategoryDeleted)
      $this->articlesAndSubcategories = Doctrine::getTable('ArticleCategory')->getArticlesAndSubcategories($categoryId);
  }

  public function executeSaveOrder(sfWebRequest $request)
  {
    if ($request->isMethod('POST'))
    {
      $articleCategory = $request->getParameter('setOrder');
      $order = 1;

      foreach ($articleCategory as $articleCategoryId)
      {
        Doctrine::getTable('ArticleCategory')->updateOrder($articleCategoryId, $order);
        $order++;
      }

      $this->getUser()->setFlash('notice', 'Dane zostały zapisane pomyślnie.');
      artTask::clearCache();
      $this->forward('pa_category', 'setOrder');
    }
  }

  public function executeDelete(sfWebRequest $request)
  {
    $request->checkCSRFProtection();

    $this->dispatcher->notify(new sfEvent($this, 'admin.delete_object', array('object' => $this->getRoute()->getObject())));
    $object = $this->getRoute()->getObject();

    if ($object->canBeDeleted() && $object->delete())
      $this->getUser()->setFlash('notice', 'Element został usunięty pomyślnie.');

    $this->redirect('@pa_category' . $this->configuration->getFollowParametersStringWithQuestionMark($request));
  }
}
