<?php if ($article->hasMeta()): ?>
  <div class="blog_head">
    <div class="blogpost_meta">
      <span><?= $article->getCreatedAt(); ?></span>
      <?php if ($article->hasAuthor()): ?>
        <span><i><?= (is_object($article->getCreator())) ? $article->getCreator()->getName() : __t("Użytkownik anonimowy"); ?></i></span>
      <?php endif; ?>

      <?php $categories = $article->getCategories(); ?>
      <?php if (is_object($categories)): ?>
        <span>
          <?php foreach ($categories as $key => $categoryObject): ?>
            <a href="<?= $categoryObject->getUrl() ?>">
              <?= $categoryObject->getTitle(); ?></a>
            <?= ($key < $categories->count() - 1) ? ',' : ''; ?>
          <?php endforeach; ?>
        </span>
      <?php endif; ?>

      <?php if ($article->hasTags() && $article->getTags()->count() > 0): ?>
        <span><?= __t("Tagi:") ?> 
          <?php foreach ($article->getTags() as $key => $tag): ?>
            <?= ($key != 0) ? ',' : ''; ?>
            <a href="<?= url_for('@search?searchText=' . $tag->getName()); ?>"><?= $tag->getName() ?></a>
          <?php endforeach; ?> 
        </span>
      <?php endif; ?>

      <?php if ($article->hasViews() && $article->getViews() != ''): ?>
        <span><?= __('Wyświetlenia: '); ?>
          <a href="#"><?= $article->getViews() ?></a>
        </span>
      <?php endif; ?>
    </div>
  </div><!-- .blog_head -->
<?php endif; ?>