<?php

/**
 * 
 */
class artCmsPluginUtilitiesActions extends artCmsPluginActions {

    /**
   * 
   * @param sfWebRequest $request
   * @throws sfException
   */
  public function executeRedirector(sfWebRequest $request) {

    $object = $this->getObject($request);

    if (!empty($object)) {
      $this->getRequest()->setParameter('object', $object);
      $module = $object->getLayout()->getModule();
      $module = str_replace("_category", "", $module); // Usuwa prefix "_category" z nazwy modułu

      if (get_class($object) == 'Category')
        $action = "list";
      else
        $action = NULL;

      if (get_class($object) == 'Article')
        $action = "show";

      if (is_null($action)) {
        throw new sfException(sprintf('Dla modelu "%s", nie zdefiniowano akcji.', get_class($object)));
      }

      if (!in_array($module, sfConfig::get('sf_enabled_modules'))) {
        throw new sfException(sprintf("Moduł '%s' nie istnieje lub nie został włączony", $module));
      }

      $parameters = $request->getGetParameters();
      foreach ($parameters as $key => $value) {
        $this->getRequest()->setParameter($key, $value);
      }

      if (get_class($object) == 'Category')
        $this->forward($module, $action);
      else{
        $category = $object->getCategories()->getFirst(); 
        
        if (empty($category)) {
          $this->forward($module, $action);
        } else {
          $category = $category->getSlug();
          $slug = $object->getSlug();
          $this->redirect("@redirector_category?category=$category&slug=$slug");
        }
      }
    } else {
      $this->forward404();
    }
  }
  
  /**
   * 
   * @param sfWebRequest $request
   * @throws sfException
   */
  public function executeRedirectorUniqueName(sfWebRequest $request) {

    $object = $this->getObject($request);

    if (!empty($object)) {
      $this->getRequest()->setParameter('object', $object);
      $module = $object->getLayout()->getModule();
      $module = str_replace("_category", "", $module); // Usuwa prefix "_category" z nazwy modułu

      if (get_class($object) == 'Category')
        $action = "list";
      else
        $action = NULL;

      if (get_class($object) == 'Article')
        $action = "show";

      if (is_null($action)) {
        throw new sfException(sprintf('Dla modelu "%s", nie zdefiniowano akcji.', get_class($object)));
      }

      if (!in_array($module, sfConfig::get('sf_enabled_modules'))) {
        throw new sfException(sprintf("Moduł '%s' nie istnieje lub nie został włączony", $module));
      }

      $parameters = $request->getGetParameters();
      foreach ($parameters as $key => $value) {
        $this->getRequest()->setParameter($key, $value);
      }

      if (get_class($object) == 'Category')
        $this->forward($module,$action);
      else{
        $category = $object->getCategories()->getFirst(); 
        
        if (empty($category)) {
          $this->redirect('@redirector?slug='.$object->getSlug());
        } else {
          $category = $category->getSlug();
          $slug = $object->getSlug();
          $this->redirect("@redirector_category?category=$category&slug=$slug");
        }
      }
    } else {
      $this->forward404();
    }
  }

  public function executeRedirectorCategory(sfWebRequest $request) {
    $object = $this->getRequest()->getParameter('object', false);
    
    if (!$object)
      $object = $this->getObject($request);
    
    if (!empty($object)) {
      $this->getRequest()->setParameter('object', $object);
      $module = $object->getLayout()->getModule();
      $module = str_replace("_category", "", $module); // Usuwa prefix "_category" z nazwy modułu

      if (get_class($object) == 'Category')
        $action = "list";
      else
        $action = NULL;

      if (get_class($object) == 'Article')
        $action = "show";

      if (is_null($action)) {
        throw new sfException(sprintf('Dla modelu "%s", nie zdefiniowano akcji.', get_class($object)));
      }

      if (!in_array($module, sfConfig::get('sf_enabled_modules'))) {
        throw new sfException(sprintf("Moduł '%s' nie istnieje lub nie został włączony", $module));
      }

      $parameters = $request->getGetParameters();
      foreach ($parameters as $key => $value) {
        $this->getRequest()->setParameter($key, $value);
      }

      $this->forward($module, $action);
    } else {
      $this->forward404();
    }
  }
  
  /**
   * 
   * @param sfWebRequest $request
   */
  public function executePlaceHold(sfWebRequest $request) {
    $this->setLayout(false);
    $get = $request->getGetParameters();

    if (isset($get)) {
      $imagedata = explode('-', key($get));

      if (!is_array($imagedata) || count($imagedata) != 4) {
        $this->forward404("Niepoprawny link ? placeholder?350-150-CCCCCC-969696&text=Test");
      }

      $this->getResponse()->setHttpHeader('Content-Type', 'image/png');

      $this->createImage($imagedata[0], $imagedata[1], $imagedata[2], $imagedata[3]);
    }

    return '';
  }
  public function executeImage(sfWebRequest $request) {
    $this->setLayout(false);
    $get = $request->getGetParameters();

    if (isset($get)) {
      $imagedata = explode('-', key($get));

      if (!is_array($imagedata) || count($imagedata) != 4) {
        $this->forward404("Niepoprawny link ? placeholder?350-150-CCCCCC-969696&text=Test");
      }

      $this->getResponse()->setHttpHeader('Content-Type', 'image/png');

      $this->createImageWithIcon($imagedata[0], $imagedata[1], $imagedata[2], $imagedata[3]);
    }

    return '';
  }

  public function createImage($width = 350, $height = 150, $bg_color = 'CCCCCC', $txt_color = '969696') {

    $text = $this->getRequestParameter('text', "$width X $height");
    $image = ImageCreate($width, $height);

    $bg_color = ImageColorAllocate($image, base_convert(substr($bg_color, 0, 2), 16, 10), base_convert(substr($bg_color, 2, 2), 16, 10), base_convert(substr($bg_color, 4, 2), 16, 10));
    $txt_color = ImageColorAllocate($image, base_convert(substr($txt_color, 0, 2), 16, 10), base_convert(substr($txt_color, 2, 2), 16, 10), base_convert(substr($txt_color, 4, 2), 16, 10));

    ImageFill($image, 0, 0, $bg_color);
    $fontsize = ($width > $height) ? ($height / 10) : ($width / 10);

    imagettftext($image, $fontsize, 0, ($width / 2) - ($fontsize * 3.75), ($height / 2) + ($fontsize * 0.2), $txt_color, sfConfig::get('sf_web_dir') . '/fonts/' . 'OpenSans-Bold.ttf', $text);
    imagepng($image);
    ImageDestroy($image);
  }

  public function createImageWithIcon($width = 350, $height = 150, $bg_color = '000000', $txt_color = 'ffffff') {

    $text = $this->getRequestParameter('text', "c");
    $image = ImageCreate($width, $height);

    $bg_color = ImageColorAllocate($image, base_convert(substr($bg_color, 0, 2), 16, 10), base_convert(substr($bg_color, 2, 2), 16, 10), base_convert(substr($bg_color, 4, 2), 16, 10));
    $txt_color = ImageColorAllocate($image, base_convert(substr($txt_color, 0, 2), 16, 10), base_convert(substr($txt_color, 2, 2), 16, 10), base_convert(substr($txt_color, 4, 2), 16, 10));

    ImageFill($image, 0, 0, $bg_color);
    $fontsize = ($width > $height) ? ($height / 10) : ($width / 10);

    imagettftext($image, $fontsize + 70, 0, ($width / 2) - ($fontsize * 3.75) + 15, ($height / 2)+ 20 + ($fontsize * 0.4), $txt_color,
            sfConfig::get('sf_web_dir') . '/fonts/' . 'coreicons-webfont.ttf', $text);
    imagepng($image);
    ImageDestroy($image);
  }


  /**
   * Zmienia język strony, artykułów;
   */
  public function executeChangeLanguage(sfWebRequest $request) {
    $lang = $request->getParameter('lang');

    if (in_array($lang, sfConfig::get('sf_cultures', array('pl'))))
      $this->getUser()->setCulture($lang);
    else
      $this->getUser()->setCulture('pl');

    artTask::clearCache();
    $referer = $request->getReferer();

    if (empty($referer))
      $referer = '@homepage';

    $this->redirect($referer);
  }

  /**
   * Akcja generujaca PDF z artykulu poprzez uzycie dompdf w artLibrary.
   * Wymagany slug przy $request.
   * 
   * @param sfWebRequest $request 
   */
  public function executeGeneratePdf(sfWebRequest $request) {
    $slug = $request->getParameter('slug');
    $article = Doctrine::getTable('Article')->getArticleBySlug($slug);

    if (empty($article) || !$article->isDisplayedAndActive()) {
      $slug = Doctrine::getTable('Article')->getOtherCultureSlugBySlug($slug);

      if ($slug)
        $this->redirect('@article_pdf?slug=' . $slug);

      $this->getUser()->setNotice('Podany artykuł nie istnieje lub jest nieaktywny!');
      $this->redirect('@homepage');
    }

    $txt = $article->getDescription();
    $txt = str_replace('src="/', 'src="', $txt);
    require_once(sfConfig::get('sf_plugins_dir') . "/artLibraryPlugin/lib/dompdf/dompdf_config.inc.php");
    
    $html = '<html><body>' . $txt .'</body></html>';

    $dompdf = new DOMPDF();
    $dompdf->load_html(iconv('UTF-8', 'Windows-1250', $html));
    $dompdf->set_paper("a4", "portrait");
    $dompdf->render();
    $dompdf->stream($slug . ".pdf");
  }

  /*
   * Akcja wyszukująca podaną frazę w artykułach.
   *
   * @params sfWebRequest $request;
   * - searchText , szukana fraza.
   * - page , strona
   * - limit , limit elementów na stronie.
   */

  public function executeSearch(sfWebRequest $request) {
    $this->searchText = $searchText = $request->getParameter('searchText', '');

    $this->page = $request->getParameter('page', 1);
    $this->limit = $request->getParameter('limit', 10);
    $this->count = Doctrine_Core::getTable('Article')->getArticleSearchCount($searchText);
    $this->offset = ($this->page - 1) * $this->limit;
    $this->page_count = ceil($this->count / $this->limit);

    $this->articles = Doctrine_Core::getTable('Article')->getArticleSearch($searchText);
    $searchText = $this->getUser()->setAttribute('searchText', $searchText);
    
    $this->setLayout('layout_FullWidth');
  }

}
