<?php

require_once dirname(__FILE__) . '/facebook-php-sdk/src/facebook.php';


class artFacebook
{

  /**
   *
   * @var Facebook
   */
  public static $client = null;

//  public static function getLoginUrl($params = array())
//  {
//    $params = array(
//        'redirect_uri' => url_for('@facebook_connect_signin', true)
//    );
//
//    return self::getFacebookClient()->getLoginUrl($params);
//  }

  /**
   *
   * @return Facebook
   */
  public static function getFacebookClient()
  {
    if (self::$client === null)
    {
      $params = array(
          'appId' => self::getApiKey(),
          'secret' => self::getApiSecret(),
      );

      self::$client = new Facebook($params);
    }

    if (!self::$client)
      error_log('Could not create facebook client.');

    return self::$client;
  }

  public static function getUser()
  {
    return self::getFacebookClient()->getUser();
  }

  public static function isUserConnected()
  {
    try
    {
      $userProfile = artFacebook::getFacebookApi('/me');
      
      return true;
    }
    catch (Exception $e)
    {
      return false;
    }
  }

  public static function getFbUserId()
  {
    try
    {
      $userProfile = artFacebook::getFacebookApi('/me');
    }
    catch (Exception $e)
    {
      return 0;
    }

    return $userProfile['id'];
  }
  public static function signOut($user)
  {
     artFacebook::getFacebookClient()->destroySession();
  }
  public static function getFacebookApi($param)
  {
    return self::getFacebookClient()->api($param);
  }

  public static function getApiKey()
  {
    return sfConfig::get('app_facebook_api_key');
  }

  public static function getApiSecret()
  {
    return sfConfig::get('app_facebook_api_secret');
  }
  
  public static function getPageId()
  {
    return sfConfig::get('app_facebook_page_id');
  }
  
  public static function getSigninUrl($absolute = true)
  {
    return url_for('@'. sfConfig::get('app_facebook_signin_url','facebook_signin'), $absolute);
  }
  
  public static function getRegisterUrl($absolute = true)
  {
    return url_for('@'. sfConfig::get('app_facebook_register_url','facebook_register'), $absolute);
  }
  
  public static function getUrlAfterRegistration($absolute = true)
  {
    return url_for('@' . sfConfig::get('app_facebook_url_after_registration'), $absolute);
  }
  
  public static function getUrlAfterAccountLink($absolute = true)
  {
    return url_for('@' . sfConfig::get('app_facebook_url_after_account_link'), $absolute);
  }

  public static function getLocale($culture = null)
  {
    if (is_null($culture))
      $culture = sfContext::getInstance()->getUser()->getCulture();

    $culture_to_locale = array(
        'pl' => 'pl_PL',
        'fr' => 'fr_FR',
        'en' => 'en_US',
        'de' => 'de_DE',
    );

    return array_key_exists($culture, $culture_to_locale) ? $culture_to_locale[$culture] : 'en_US';
  }

}
