<?php

class PluginfacebookActions extends artActions
{
  
  /**
   * 
   * @param sfWebRequest $request
   */
  public function executeSignin(sfWebRequest $request)
  {
    try
    {
      $userProfile = artFacebook::getFacebookApi('/me');
      $sfGuardUserProfile = Doctrine::getTable('sfGuardUserProfile')->getGuardUser($userProfile['id']);
      
      if ($sfGuardUserProfile)
        $redirectUrl = Redirector::get ('Facebook_AfterSignin');
      else
      {
          $redirectUrl = Redirector::get ('Facebook_Signin_To_Register');
          $noLogin = true;      
      }
      
      //logowanie do serwisu
      if (!$noLogin)
      {
        if ($sfGuardUserProfile->getSfGuardUser()->getIsActive())
          $this->getUser()->signIn($sfGuardUserProfile->getSfGuardUser(), true);
        else
           $this->getUser()->setError('Your account is inactive');
      }
    }
    catch (Exception $e)
    {
      $this->getUser()->setFlash('facebook_nologin', 'true');
      $this->getUser()->setError('Error'.$e);
      $redirectUrl = Redirector::get ('Facebook_AfterSignin_Error');
    }

    $this->redirect('@' . $redirectUrl);
  }
  
  public function executeFBRegister($request)
  {
    $this->getUser()->setFlash('facebook_nologin', 'true');
  }
  
  public function executeAfterRegister(sfWebRequest $request)
  {
    $registrationArray = artFacebook::getFacebookClient()->getSignedRequest();
    if (isset ($registrationArray['registration']['email']))
    {
      $guardUser = Doctrine::getTable('sfGuardUser')->findOneByEmailAddress($registrationArray['registration']['email']);

      if (!$guardUser)
      {
        $user = $this->registerThroughFacebook($registrationArray);
        $this->getUser()->setNotice('Facebook registration complete.');

        $this->getUser()->signIn($user);
    //    ArtSimpleMessenger::sendRegistrationMessage($user);
      }
      else
      {
        $email = $guardUser->getEmailAddress();
        if ($this->getUser()->isAuthenticated())
          $email = $this->getUser()->getGuardUser()->getEmailAddress();
        
        if ($email == $registrationArray['registration']['email'])
        {
          $user = $this->linkAccountWithFacebook($guardUser, $registrationArray);
          $this->getUser()->setNotice('Facebook registration complete.');
          if (!$this->getUser()->isAuthenticated())
            $this->getUser()->signIn($user);

        }
        else
          $this->getUser()->setError('Your email and Facebook email doesn\'t match');
      }
    }else
      $this->getUser()->setError('Facebook data mismatch'.'<br/>'.print_r($registrationArray,true));
    
    $this->redirect(Redirector::get ('Facebook_AfterRegister'));
  }
  
  public function executeLinkAndFanpage(sfWebRequest $request)
  {
    $this->uniqueName = $request->getParameter('uniqueName','facebookLinkAndFanpage');
    $this->showFanpage = $request->getParameter('showFanpage',true);
    $this->showRegister = $request->getParameter('showRegister',true);
  }
  
 
  public function registerThroughFacebook($registrationArray)
  {
    extract($registrationArray['registration']);
    
    $user = new sfGuardUser();
    $user->setFirstName($first_name);
    $user->setLastName($last_name);
    $user->setEmailAddress($email);
    $user->setUsername($email);
    $user->setIsActive(1);
    $user->setPassword($password);
    $user->save();
    
    $object = new sfGuardUserProfile();
    $object->setId($user->getId());
    $object->setFacebookUid($registrationArray['user_id']);
    $object->setFirstName($first_name);
    $object->setLastName($last_name);
    $object->save();
    
    return $user;
  }

  public function linkAccountWithFacebook($user, $registrationArray)
  {
    extract($registrationArray['registration']);
    
   
    $object = $user->getProfile();
    if ($object == null)
    {
      $object = new sfGuardUserProfile();
      $object->setId($user->getId());
      artDebug::logError("facebook/linkAccountWithFacebook: No user profile");
    }
    $object->setFacebookUid($registrationArray['user_id']);
    $object->save();
    
    return $user;
  }
  
  
}


