<?php
/**
 * Klasa odpowiada za wyciąganie łańcuchów i18n z plików PHP.
 *
 * @see taski, ../task/*
 */

class artI18nExtract extends sfI18nApplicationExtract
{
    /**
     * Wyciąga tłumaczone ciągi znaków z pluginu.
     */
    public function extractPlugin($plugin)
    {
        $path = sfConfig::get('sf_plugins_dir') . '/' . $plugin;

        if (is_dir($path)) {
            $this->extractFromPhpFiles($path);
        } else {
            return false;
        }
        return true;
    }

    /**
     * Wyciąga tłumaczenie z ścieżek podanych w app.
     */
    public function extractFromAdditionalPaths()
    {
        $includeMorePaths = sfConfig::get('app_art_i18n_plugin_extract_additional_enabled', false);

        if (isset($includeMorePaths) && ($includeMorePaths == true)) {
            $paths = sfConfig::get('app_art_i18n_plugin_extract_additional_paths');

            foreach ($paths as $path) {
                $this->extractFromPhpFiles($path);
            }

            return true;
        }

        return false;
    }
}
