<?php

class i18nRoutingFilter extends sfFilter
{
  protected function isFirstRequest($set = null)
  {
    if (!is_null($set))
    {
      $this->context->getUser()->setAttribute('isFirstRequest', $set);
    }

    return $this->context->getUser()->getAttribute('isFirstRequest', true);
  }

  protected function getCookieName()
  {
    return sfConfig::get('app_art_i18n_plugin_culture_cookie_name', 'culture_cookie');
  }

  protected function getCookieCulture()
  {
    return $this->context->getRequest()->getCookie($this->getCookieName());
  }

  protected function setCookieCulture($culture)
  {
    $cookie_name = $this->getCookieName();
    $cookie_length = sfConfig::get('app_sf_guard_plugin_remember_key_expiration_age',1296000);

    $this->context->getResponse()->setCookie($cookie_name, $culture, time() + $cookie_length);
  }

  protected function setCulture($culture)
  {
    $this->context->getUser()->setCulture($culture);
    $this->setCookieCulture($culture);
  }

  public function execute($filterChain)
  {
    $sf_culture = $this->context->getRequest()->getParameter('sf_culture', null);
    $cookie_culture = $this->getCookieCulture();

    if (is_null($sf_culture))
    {
      if ($this->isFirstRequest())
      {
        $culture = empty($cookie_culture) ? $this->context->getRequest()->getPreferredCulture(sfConfig::get('sf_cultures',array('pl'))) : $cookie_culture;

        $this->setCulture($culture);
        $this->isFirstRequest(false);
      }

      $this->context->getController()->redirect('@homepage');
    }
    else
    {
      if ($sf_culture != $cookie_culture)
      {
        $this->setCookieCulture($sf_culture);
      }
    }
  }
}
