<?php

/**
 * Formularz backendowy zmiany I18nTranslations
 * @subpackage artCmsPlugin

 */
class PluginFlatyI18nTranslationsForm extends Basei18nTranslationsForm {
  public function configure() {
    $this->useFields(array('id', 'cat_id', 'source', 'target', 'comments'));
    
    $this->setWidget('target', new sfWidgetFormTextarea(array(), array('class' => 'no-ckeditor')));
    $this->setWidget('source', new sfWidgetFormInputText());
    $this->setWidget('comments', new sfWidgetFormInputText());
    
    $this->getWidgetSchema()->setLabel('target', 'Tekst docelowy');
    $this->getWidgetSchema()->setLabel('cat_id', 'Kategoria tłumaczenia');
    
    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', $this->getWidget($name)->getAttribute('class').' form-control');
    }
    
    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
}
