<?php


function __($text, $args = array(), $catalogue = false, $edit = false)
{
    if ($catalogue == false) {

        $newCatalogue = sfConfig::get('app_art_i18n_plugin_category', false);

        if ($newCatalogue) {
            $catalogue = $newCatalogue;
        } else {
            $catalogue = sfConfig::get('app_art_i18n_plugin_catalogue_name','messages');
        }
    }

    if (sfConfig::get('sf_i18n')) {
        return sfContext::getInstance()->getI18N()->__($text, $args, $catalogue, $edit);
    } else {
        if (empty($args)) {
            $args = array();
        }
        foreach ($args as $key => $value) {
            if (is_object($value) && method_exists($value, '__toString')) {
                $args[$key] = $value->__toString();
            }
        }

        return strtr($text, $args);
    }
}


function __t($text, $args = array(), $catalogue = false, $edit = true)
{
    if ($catalogue == false) {

        $newCatalogue = sfConfig::get('app_art_i18n_plugin_category', false);

        if ($newCatalogue) {
            $catalogue = $newCatalogue;
        } else {
            $catalogue = 'messages';
        }
    }

    if (sfConfig::get('sf_i18n')) {
        return sfContext::getInstance()->getI18N()->__($text, $args, $catalogue, $edit);
    } else {
        if (empty($args)) {
            $args = array();
        }

        foreach ($args as $key => $value) {
            if (is_object($value) && method_exists($value, '__toString')) {
                $args[$key] = $value->__toString();
            }
        }

        return strtr($text, $args);
    }
}

function __tt($text, $args = array(), $catalogue = false, $edit = 'title')
{
    if ($catalogue == false) {

        $newCatalogue = sfConfig::get('app_art_i18n_plugin_category', false);

        if ($newCatalogue) {
            $catalogue = $newCatalogue;
        } else {
            $catalogue = 'messages';
        }
    }

    if (sfConfig::get('sf_i18n')) {
        return sfContext::getInstance()->getI18N()->__($text, $args, $catalogue, $edit);
    } else {
        if (empty($args)) {
            $args = array();
        }

        foreach ($args as $key => $value) {
            if (is_object($value) && method_exists($value, '__toString')) {
                $args[$key] = $value->__toString();
            }
        }

        return strtr($text, $args);
    }
}

function format_number_choice($text, $args = array(), $number, $catalogue = 'messages')
{
    $translated = __($text, $args, $catalogue);

    $choice = new sfChoiceFormat();

    $retval = $choice->format($translated, $number);

    if ($retval === false) {
        throw new sfException(sprintf('Unable to parse your choice "%s".', $translated));
    }

    return $retval;
}

function format_country($country_iso, $culture = null)
{
    $c = sfCultureInfo::getInstance($culture === null ? sfContext::getInstance()->getUser()->getCulture() : $culture);
    $countries = $c->getCountries();

    return isset($countries[$country_iso]) ? $countries[$country_iso] : '';
}

function format_language($language_iso, $culture = null)
{
    $c = sfCultureInfo::getInstance($culture === null ? sfContext::getInstance()->getUser()->getCulture() : $culture);
    $languages = $c->getLanguages();

    return isset($languages[$language_iso]) ? $languages[$language_iso] : '';
}
