<?php

/**
 *
 */
class artMessageFormat extends sfMessageFormat {

  /**
   * @param string $string
   * @param array $args
   * @param null $catalogue
   * @param null $charset
   * @param null $edit
   * @return string
   */
  public function format($string, $args = array(), $catalogue = null, $charset = null, $edit = false) {
    $string = (string) $string;
    if (empty($charset)) {
      $charset = $this->getCharset();
    }

    $s = $this->formatString(sfToolkit::I18N_toUTF8($string, $charset), $args, $catalogue, $edit);

    return sfToolkit::I18N_toEncoding($s, $charset);
  }

  /**
   * @param string $string
   * @param array $args
   * @param null $catalogue
   * @return string
   */
  protected function formatString($string, $args = array(), $catalogue = null, $edit = false) {
    if (empty($args)) {
      $args = array();
    }

    if (empty($catalogue)) {
      $catalogue = empty($this->catalogue) ? 'messages' : $this->catalogue;
    }

    $this->loadCatalogue($catalogue);

    foreach ($this->messages[$catalogue] as $variant) {

      if (isset($variant[$string])) {
        $databaseId = $variant[$string][1];

        $target = $variant[$string];

        if (is_array($target)) {
          $target = array_shift($target);
        }

        if (empty($target)) {

          if ($edit) {
            return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1] . $this->addEditLink($databaseId);
          } else {
            return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1];
          }
        }

        if ($edit) {
          return $this->replaceArgs($target . $this->addEditLink($databaseId), $args);
        } else {
          return $this->replaceArgs($target, $args);
        }
      }
    }

    $this->source->append($string);

    if ($edit) {
      return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1] . $this->addNewLink($string, $catalogue);
    } else {
      return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1];
    }
  }

  /**
   * @param $databaseId
   * @return string
   */
  private function addEditLink($databaseId) {
    $user = sfContext::getInstance()->getUser();
    $edit = sfContext::getInstance()->getUser()->getAttribute('i18n_edit', false);

    if ($user->isTranslator() && $edit) {
      return '
                <a class="translations" title="' . __('Zmień tłumaczenie') . '" href="javascript:void(0);"
                  onclick = "artI18nOpenTranslationEditPopup(' . $databaseId . '); 
                  ">
        <i class="icon-flag">
                  </i>
                  </a>'
      ;
    }
  }

  /**
   * @return string
   */
  private function addNewLink($text, $catalogue) {
    $user = sfContext::getInstance()->getUser();
    $edit = sfContext::getInstance()->getUser()->getAttribute('i18n_edit', false);

    if ($user->isTranslator() && $edit) {

      return '
      <a class="translations" title="' . __('Dodaj tłumaczenie') . '" href="javascript:void(0);"
                  onclick = "artI18nOpenTranslationNewPopup(\'' . html_entity_decode($text) . '\', \''.$catalogue.'\'); 
                  ">
        <i class="icon-flag">
                  </i>
                  </a>
                  '
      ;
    }
  }

}
