<?php

class i18nRoute extends sfRoute {

    protected
            $full_pattern = array(),
            $full_regex = array(),
            $full_tokens = array(),
            $full_staticPrefix = array();

    public function __construct($pattern, array $defaults = array(), array $requirements = array(), array $options = array()) {
        
        parent::__construct('tmppattern', $defaults, $requirements, $options);
        
        if (is_array($pattern)) {
            foreach ($pattern as $key => $value) {
                $pattern[$key] = trim($value);
            }
        } else {
            $old_pattern = trim($pattern);
            $pattern = array();
            $culture = sfConfig::get('sf_cultures', array('pl'));

            foreach ($culture as $key) {
                $pattern[$key] = $old_pattern;
            }
        }
        
        $this->pattern = $pattern;
        $this->full_pattern = $pattern;
    }

    public function matchesUrl($url, $context = array()) {
        
        if (!$this->compiled) {
            $this->compile();
        }

        $matches = false;

        $culture = sfConfig::get('sf_cultures', array('pl'));

        foreach ($culture as $key) {
            $this->pattern = $this->full_pattern[$key];
            $this->tokens = $this->full_tokens[$key];
            $this->regex = $this->full_regex[$key];
            $this->staticPrefix = $this->full_staticPrefix[$key];

            $matches = parent::matchesUrl($url, $context);
            if ($matches !== false) {
                $matches['sf_culture'] = $key;
                return $matches;
            }
        }
        return false;
    }

    public function generate($params, $context = array(), $absolute = false, $culture = false) {

        if (!$this->compiled) {
            $this->compile();
        }
        
//        
//        var_dump($culture); 
//        die(); 
//        
        if (!$culture)
          $culture = sfContext::getInstance()->getUser()->getCulture(); 
        
        $this->pattern = $this->full_pattern[$culture];
        $this->tokens = $this->full_tokens[$culture];
        $this->regex = $this->full_regex[$culture];
        $this->staticPrefix = $this->full_staticPrefix[$culture];

        return parent::generate($params, $context, $absolute);
    }

    public function compile() {
        if ($this->compiled) {
            return;
        }

        $this->full_tokens = array();
        $this->full_regex = array();
        $this->full_staticPrefix = array();

        $culture = sfConfig::get('sf_cultures', array('pl'));

        foreach ($culture as $key) {
            $this->compiled = false;
            $this->pattern = $this->full_pattern[$key];
            parent::compile();
            $this->full_tokens[$key] = $this->tokens;
            $this->full_regex[$key] = $this->regex;
            $this->full_staticPrefix[$key] = $this->staticPrefix;
        }

        $this->compiled = true;
    }

    public function serialize() {
        $this->compile();

        return serialize(array($this->tokens, $this->defaultOptions, $this->options, 
            $this->pattern, $this->staticPrefix, $this->regex, $this->variables, 
            $this->defaults, $this->requirements, $this->suffix, $this->full_pattern, 
            $this->full_tokens, $this->full_regex, $this->full_staticPrefix));
    }

    public function unserialize($data) {
        
        list($this->tokens, $this->defaultOptions, $this->options, $this->pattern, 
                $this->staticPrefix, $this->regex, $this->variables, $this->defaults, 
                $this->requirements, $this->suffix, $this->full_pattern, $this->full_tokens, 
                $this->full_regex, $this->full_staticPrefix) = unserialize($data);
        
        $this->compiled = true;
    }

}
