<div id="i18n-translations">
  <div class="fm popup art-configuration list">
    <div class="popup-header"></div>
  </div>
  <div class="popup-body">
    <table class="table table-stripped table-bordered table-hover">
      <thead>
        <tr>
          <th>Kategoria</th>
          <th>Tekst źródłowy</th>
          <th>Tekst docelowy</th>
          <th>Komentarz</th>
          <th>Akcje</th>
        </tr>
      </thead>
      <tbody>
        <?php $records = $pager->getResults(); ?>
        <?php foreach ($records as $record): ?>
          <tr>
            <td><?php echo $record->getCategory() ?></td>
            <td><?php echo $record->getSource() ?></td>
            <td><?php echo $record->getTarget() ?></td>
            <td><?php echo $record->getComments() ?></td>
            <td>
              <?php
              echo jq_link_to_remote('Edytuj', array(
                  'update' => 'i18n-translations',
                  'url' => '@art_i18n_single_translation_edit?id=' . $record->getId() . '&page=' . $pager->getPage(),
                  'loading' => 'startIndicator($("#i18n-translations"));',
                  'complete' => 'stopIndicator($("#i18n-translations"));',
                      ), array(
                  'class' => 'btn',
              ));
              ?>
            </td>
          </tr>

        <?php endforeach ?>
      </tbody>
    </table>
    <div class="clear"></div>
    <?php include_partial('ajax_paginator', array('id' => 'i18n-translations', 'routing' => 'art_i18nTranslations_list', 'pager' => $pager)); ?>
  </div>

  <div class="popup-footer">
    <?php echo btn_to(__('Zamknij'), '', array('no_link' => true, 'class' => 'fr', 'url_for' => false, 'onclick' => "$('#i18n-translations').dialog('destroy');")); ?>
  </div>
</div>