<?php
/**
 * artLessPluginConfiguration Klasa initializująca pluginu.
 *
 * @package    artLessPlugin
 * @subpackage konfiguracja

 * @version    1.0.0
 */

class artLessPluginConfiguration extends sfPluginConfiguration
{
  /**
   * @see sfPluginConfiguration
   */

  public function initialize()
  {
    // Jeżeli opcja less_plugin_compile w pliku YAML (app.yml) jest ustawiona na true.

    if (sfConfig::get('app_art_less_plugin_compile', false))
    {
      // Rejestruje listenera do eventu routing.load_configuration.

      $this->dispatcher->connect(
        'context.load_factories',
        array('artLESSListeners', 'findAndCompile')
      );

      // Jeśli app_less_plugin_toolbar (TRUE, jako opcja domyslna)

      if (sfConfig::get('sf_web_debug') && sfConfig::get('app_art_less_plugin_toolbar', true))
      {
        // Dodaje nową pozycje do paska debugera

        $this->dispatcher->connect('debug.web.load_panels', array(
          'artWebDebugPanelLESS',
          'listenToLoadDebugWebPanelEvent'
        ));
      }
    }

    $this->dispatcher->connect(
      'less_js.compile',
      array('artLESSListeners', 'findAndFixContentLinks')
    );
  }
}
