<?php
/**
 * artLESSConfig klasa konfiguracyjna.
 *
 * @package    artLESSPlugin
 * @subpackage lib

 * @version    1.0.0
 */

class artLESSConfig
{
  /**
   * Sprawdzanie daty edycji pliku przed kompilacją.
   *
   * @var boolean
   */
  protected $checkDates;

  /**
   * Kompresja plików CSS
   *
   * @var boolean
   */
  protected $useCompression;
  
  /**
   * Łączenie obrazków w spraity. 
   *
   * @var boolean
   */
  protected $makeSprite = false;

  /**
   * Kompilacja CLIENT SIDE
   *
   * @var boolean
   */
  protected $compileClientSide = true;

  /**
   * Naprawa zduplikowanych lini kodu.
   *
   * @var boolean
   */
  protected $fixDuplicate = false;

  /**
   * Używanie lessphp do kompilacji CLIENT SIDE.
   *
   * @var boolean
   */
  protected $useLessphp = false;
  
  /**
   * Tworzenie instancji.
   *
   * @param   boolean   $checkDates
   * @param   boolean   $useCompression
   */
  public function __construct($checkDates = true, $useCompression = false)
  {
    $this->checkDates     = $checkDates;
    $this->useCompression = $useCompression;
  }

  /**
   * Czy sprawdzamy daty plików przed kompilacja ?
   *
   * @return  boolean
   */
  public function isCheckDates()
  {
    return $this->checkDates;
  }

  /**
   * Czy łączyć obrazki w spraity. 
   *
   * @return  boolean
   */
  public function isSpriteJoinerEnabled()
  {
    return $this->makeSprite;
  }

  /**
   * Ustawia zmienną $checkDates przed kompilacją.
   *
   * @param   boolean $checkDates
   */
  public function setIsCheckDates($checkDates)
  {
    $this->checkDates = $checkDates;
  }

  /**
   * Czy używamy kopresji dla plików CSS.
   *
   * @return  boolean
   */
  public function isUseCompression()
  {
    return $this->useCompression;
  }

  /**
   * Ustawia zmienną $useCompression, Kompresja plików CSS
   *
   * @param   boolean $useCompression
   */
  public function setIsUseCompression($useCompression)
  {
    $this->useCompression = $useCompression;
  }

  /**
   * Zwraca sciezkę do katalogu z plikami CSS.
   *
   * @return  string ścieżka do folderu gdzie znajdują się pliki CSS.
   */
  public function getCssPaths()
  {
    return 'web/css/';
  }

  /**
   * Zwraca sciezkę do katalogu z plikami LESS.
   *
   * @return  string ścieżka do folderu gdzie znajdują się pliki LESS.
   */
  public function getLessPaths()
  {
    return 'web/less/';
  }

  /**
   * Zwraca sciezkę do pliku less.js
   *
   * @return  string scieżka z nawą pliku.
   */
  public function getLessJsPath()
  {
    return '/artLessPlugin/js/less-1.3.0.min.js';
  }

  /**
   * @return  boolean  Zwraca czy kompilacja odbywa się poprzez CLIENT SIDE.
   */
  public function isClientSideCompilation()
  {
    return $this->compileClientSide;
  }

  /**
   * @return boolean 	 Zwaraca czy uzywany jest lessphp.
   */
  public function isUseLessphp()
  {
    return $this->useLessphp;
  }

  /**
   * Włącza kompilację CLIENT SIDE.
   *
   * @param   boolean $clientSide
   */
  public function setIsClientSideCompilation($clientSide)
  {
    $this->compileClientSide = $clientSide;
  }

  /**
   * @return  boolean  Naprawia zduplikowane linie kodu.
   */
  public function getFixDuplicate()
  {
    return $this->fixDuplicate;
  }

  /**
   * Włącza naprawę zduplikowanych lini kodu.
   *
   * @param   boolean $clientSide
   */
  public function setFixDuplicate($fix)
  {
    $this->fixDuplicate = $fix;
  }

  /**
   * Zwraca info z Debugera, o aktualnej kompilacji.
   *
   * @return  array state
   */
  public function getDebugInfo()
  {
    return array(
      'dates'       => var_export($this->isCheckDates(), true),
      'compress'    => var_export($this->isUseCompression(), true),
      'less'        => $this->getLessPaths(),
      'css'         => $this->getCssPaths(),
      'sprite_joiner' => var_export($this->isSpriteJoinerEnabled(), true)
    );
  }
}
