<?php

/**
 * Zwraca opcje konfiguracyjne z pliku YAML.
 *
 * @package    artLESSPlugin
 * @subpackage lib

 * @version    1.0.0
 */
class artYamlLESSConfig extends artLESSConfig {

  /**
   * Łączenie obrazków w spraity. 
   */
  public function isSpriteJoinerEnabled() {
    return sfConfig::get('app_art_less_plugin_sprite_joiner', parent::isSpriteJoinerEnabled());
  }

  /**
   * Sprawdzanie dat plików.
   */
  public function isCheckDates() {
    return sfConfig::get('app_art_less_plugin_check_dates', parent::isCheckDates());
  }

  /**
   * Używanie kompresji
   */
  public function isUseCompression() {
    return sfConfig::get('app_art_less_plugin_use_compression', parent::isUseCompression());
  }

  /**
   * Nagłówek CSS
   */
  public function getCssHeaderText() {
    return '/*' . sfConfig::get('app_art_less_plugin_css_header', 'UWAGA ! PLIK WYGENEROWANY AUTOMATYCZNIE. NIE EDYTUJ ! ZMIANY NA PLIKU ZOSTANĄ PORZUCONE.W CELU EDYCJI ZMIEŃ PLIK LESS') . ' */';
  }

  /**
   * Pobieranie ściezki do CSS
   */
  public function getCssPaths() {
    return artLESSUtils::getSepFixedPath(sfConfig::get('sf_web_dir')) . '/css/';
  }

  /**
   * Pobieranie ścieżki do LESS
   */
  public function getLessPaths() {
    return artLESSUtils::getSepFixedPath(sfConfig::get('sf_web_dir')) . '/less/';
  }

  /**
   * Pobieranie ściezko do pliku less.js.
   * @see artLESSConfig
   */
  public function getLessJsPath() {
    return sfConfig::get('app_art_less_plugin_js_lib', parent::getLessJsPath());
  }

  /**
   * Kompilacja CLIENT SIDE.
   * @see artLESSConfig
   */
  public function isClientSideCompilation() {
    return sfConfig::get('app_art_less_plugin_use_js', parent::isClientSideCompilation());
  }

  /**
   * Używanie lessphp.
   * @see artLESSConfig
   */
  public function isUseLessphp() {
    return sfConfig::get('app_art_less_plugin_use_lessphp', parent::isClientSideCompilation());
  }

  /**
   * Naprawa duplikatów.
   * @see artLESSConfig
   */
  public function getFixDuplicate() {
    return sfConfig::get('app_art_less_plugin_fix_duplicate', parent::getFixDuplicate());
  }

}