<?php
/**
 * artLESSDependency klasa sprawdzająca zależności.
 *
 * @package    artLESSPlugin
 * @subpackage less

 * @version    1.0.0
 *
 */

class artLESSDependency
{
  /**
   * @var string $path. Katalog bazowy.
   */
  protected $path;

  /**
   * @var boolean $check.
   */
  protected $check = false;

  /**
   * @param   string  $path   Katalog WEB
   * @param   boolean $check
   */
  public function __construct($path, $check)
  {
    if (!artLESSUtils::isPathAbsolute($path) || !is_dir($path))
    {
      throw new InvalidArgumentException("Zdefiniowany katalog less musi zostać utworzony");
    }
    else
    {
      $this->path = preg_replace('/\/$/', '', $path);
    }
    $this->check = $check;
  }

  /**
   * Zwraca czas modyfikacji pliku.
   *
   * @param   string          $file   nazwa pliku
   * 
   * @return  integer|boolean , czas ostatniej modyfikacji pliku.
   */
  public function getMtime($lessFile)
  {
    $mtime = filemtime($lessFile);

    if ($mtime !== false && $this->check)
    {
      $deps = $this->computeDependencies($lessFile, array());
      foreach ($deps as $file)
      {
        if (is_file($file))
        {
          $mtime = max($mtime, filemtime($file));
        }
      }
    }

    return $mtime;
  }
 
  /**
   * Sprawdza zalezności.
   *
   * @param   file  $lessFile , plik less
   * @param   array $deps     , istniejące zalezności.
   * 
   * @return  array           , tablica z zaleznościami, po aktualizacji.
   */
  protected function computeDependencies($lessFile, array $deps)
  {
    if (!artLESSUtils::isPathAbsolute($lessFile))
    {
      $lessFile = realpath($this->path . '/' . $lessFile);
    }

    if (is_file($lessFile))
    {
      $less = artLESSUtils::stripLessComments(file_get_contents($lessFile));
      if (preg_match_all("/@import\s+(?:url\s*\(\s*)?(['\"])(.*?)\\1\s*(?:\))?\s*;/", $less, $files))
      {
        foreach ($files[2] as $file)
        {
          if (!preg_match('/\.(le?|c)ss$/', $file))
          {
            $file .= '.less';
          }
          if (artLESSUtils::isPathAbsolute($file))
          {
            $file = realpath($this->path . $file);
          }
          else
          {
            $file = realpath(dirname($lessFile) . '/' . $file);
          }
          if ($file !== false && !in_array($file, $deps) && !preg_match('/\.css$/', $file))
          {
            $deps[] = $file;
            // Rekursywnie dodaje zalezności.
            $deps += $this->computeDependencies($file, $deps);
          }
        }
      }
      return $deps;
    }
    else
    {
      return array();
    }
  }
}
