<?php

/**
 * LESS listener.
 *
 * @package    artLESSPlugin
 * @subpackage less

 * @version    1.0.0
 */

class artLESSListeners
{
  /**
   * Szuka i naprawia linki z stylami less.
   * @param   sfEvent       $event
   */
  static public function findAndFixContentLinks(sfEvent $event)
  {
    $response = $event->getSubject();
    $hasLess  = false;
    
    foreach ($response->getStylesheets() as $file => $options)
    {
      if (
           '.less' === substr($file, -5) && 
           (!isset($options['type']) || 'text/less' !== $options['type'])
         )
      {
        $response->removeStylesheet($file);
        if (artLESS::getConfig()->isClientSideCompilation())
        {
          $response->addStylesheet(
            '/less/' . $file, '', array_merge($options, array('type' => 'text/less'))
          );
          $hasLess = true;
        }
        else
        {
          $response->addStylesheet('/css/' . substr($file, 0, -5) . '.css', '', $options);
        }
      }
    }

    if ($hasLess)
    {
      if (sfConfig::get('symfony.asset.javascripts_included', false))
      {
        throw new LogicException(
          "The stylesheets must be included before the javascript in your layout"
        );
      }
      else
      {        
        $response->addJavascript(artLESS::getConfig()->getLessJsPath());
      }
    }
  }

  /**
   * Szuka i kompiluje pliki LESS do CSS
   *
   * @param   sfEvent $event
   */
  static public function findAndCompile(sfEvent $event)
  {
    // Uruchomienie timera.

    $timer = sfTimerManager::getTimer('Less compilation');

    // Tworzenie nowego obiektu helpera & kompilacja.
    $less = new artLESS();
    
    foreach ($less->findLessFiles() as $lessFile)
    {
      $less->compile($lessFile);
    }

    // Zatrzymanie timera.
    $timer->addTime();
  }
}
