<?php
/**
 * artLESSUtils Predefiniowane funkcje.
 *
 * @package    artLESSPlugin
 * @subpackage less

 * @version    1.0.0
 *
 */

class artLESSUtils
{
  /**
   * @param  path $path  Ścieżka.
   *
   * @return bool true, jeżeli ścieżka jest absoluna przyjmuje wartość false.
   */
  public static function isPathAbsolute($path)
  {
    if ($path[0] == '/' || $path[0] == '\\' ||
        (strlen($path) > 3 && ctype_alpha($path[0]) &&
         $path[1] == ':' &&
         ($path[2] == '\\' || $path[2] == '/')
        )
       )
    {
      return true;
    }
    return false;
  }

  /**
   * Usuwanie komentarzy w plików less.
   * 
   * @param   string  $less LESS
   * 
   * @return  string        LESS bez komentarzy.
   */
  public static function stripLessComments($less)
  {
    /* */
    $less = preg_replace('#/\*.*?\*/#ms', '', $less);
    //
    $less = preg_replace('#//.*$#m', '', $less);
    return $less;
  }

  /**
   * Zwraca ścieśkę ze zmienionymi adresami.  (\ => /)
   *
   * @param   string  $path basic path
   * 
   * @return  string
   */
  public static function getSepFixedPath($path)
  {
    return str_replace(DIRECTORY_SEPARATOR, '/', $path);
  }

  /**
   * Zwraca ścieżką do projektu.
   *
   * @param   string  $fullPath
   * 
   * @return  string
   */
  public static function getProjectRelativePath($fullPath)
  {
    return str_replace(
      self::getSepFixedPath(sfConfig::get('sf_root_dir')) . '/',
      '',
      self::getSepFixedPath($fullPath)
    );
  }

  /**
   * Sprawdza plik less, czy skompilowany.
   *
   * @param   string  $dir    a path to file
   * @param   string  $entry  a filename
   * 
   * @return  boolean
   */
  static public function isCssLessCompiled($dir, $entry)
  {
    $file = $dir . '/' . $entry;
    $fp = fopen( $file, 'r' );
    $line = stream_get_line($fp, 1024, "\n");
    fclose($fp);

    return (0 === strcmp($line, self::getCssHeader()));
  }

  /**
   * Usuwanie białych spacji, tabów itp.
   *
   * @param   string  $css
   * 
   * @return  string   skomprensowany plik CSS.
   */
  static public function getCompressedCss($css)
  {
    return str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css);
  }

  /**
   * Zwraca nagłówek pliki CSS.
   *
   * @return  string
   */
  static public function getCssHeader()
  {
    return artLESS::getConfig()->getCssHeaderText();
  }

  /**
   * Tworzenie folderu na pliki, jeżeli nie istnieje.
   *
   * @param   string  $file
   */
  static public function createFolderIfNeeded($file)
  {
    // Spraawdź czy ścieżka istnieje & uwtórz jeśli nie.

    if (!is_dir(dirname($file)))
    {
      mkdir(dirname($file), 0777, true);

      // Zmiana praw.
      chmod(dirname($file), 0777);
    }
  }

  /**
   * Naprawa i usuwanie zduplikowanych lini kodu
   *
   * @param   string  $css
   *
   * @return  string  naprawiony CSS
   */
  static public function  fixDuplicateLines($css)
  {
    $directives = array();
    $inBlock = false;
    $inComment = false;
    $output = array();

    preg_match_all('/.+/', $css, $lines);
    foreach ($lines[0] as $line)
    {
      $active = '';
      if (!$inComment)
      {
        $inComment = preg_match("#/\*#", $line);
        $active = preg_replace("#/\*.*#", '', $line);
      }

      if ($inComment)
      {
        if (preg_match("#\*/#", $line))
        {
          $inComment = false;
          $active .= preg_replace("#.*?\*/#", '', $line);
        }        
      }

      if (!$inBlock)
      {
        $output[] = $line;

        if (preg_match('/{/', $active))
        {
          $inBlock = true;
          $directives = array();
        }
      }
      else
      {
        if ($inComment)
        {
          $output[] = $line;
        }
        elseif (!in_array($line, $directives))
        {
          $output[] = $line;
          $directives[] = $line;
        }

        if (preg_match('/}/', $active))
        {
          $inBlock = false;
        }
      }
    }
    return join("\n", $output);
  }
}
