<?php

require_once(sfConfig::get('sf_plugins_dir') . '/artLessPlugin/lib/lessphp/lessc.inc.php');

class LessCompiler extends lessc {
  protected $preserveComments = true;
  
  public function __construct($fname = null) {
    parent::__construct($fname);
  }

  protected function newFormatter() {
    $className = "art_lessc_formatter_lessjs";
    if (!empty($this->formatterName)) {
      if (!is_string($this->formatterName))
        return $this->formatterName;
      $className = "lessc_formatter_$this->formatterName";
    }

    return new $className;
  }

}

class art_lessc_formatter_classic extends lessc_formatter_classic {

  public $indentChar = "  ";
  public $break = "\n";
  public $open = " {";
  public $close = "}";
  public $selectorSeparator = ", ";
  public $assignSeparator = ":";
  public $openSingle = " { ";
  public $closeSingle = " }";
  public $disableSingle = false;
  public $breakSelectors = false;
  public $compressColors = false;

  public function block($block) {
    if ($this->isEmpty($block))
      return;

    $inner = $pre = $this->indentStr();

    $isSingle = !$this->disableSingle &&
            is_null($block->type) && count($block->lines) == 1;

    if (!empty($block->selectors)) {
      $this->indentLevel++;

      if ($this->breakSelectors) {
        $selectorSeparator = $this->selectorSeparator . $this->break . $pre;
      } else {
        $selectorSeparator = $this->selectorSeparator;
      }

      echo $pre .
      implode($selectorSeparator, $block->selectors);
      if ($isSingle) {
        echo $this->openSingle;
        $inner = "";
      } else {
        echo $this->open . $this->break;
        $inner = $this->indentStr();
      }
    }

//    if (!empty($block->lines)) {
//      $glue = $this->break . $inner;
//      echo $inner . implode($glue, $block->lines);
//      if (!$isSingle && !empty($block->children)) {
//        echo $this->break;
//      }
//    }
//    die('asd');

    if (!empty($block->lines)) {
      $glue = $this->break . $inner;
      $lines = '';

      foreach ($block->lines as $key => $line) {

        if (strpos($line, "/**") !== false) {

          if (strpos($line, "/** sprite:") !== false) {
            $lines .= $glue . $line;
          } else {
            $lines .= $line;
          }
        } else {
          if ($key != 0) {
            $lines .= $glue . $line;
          } else {
            $lines .= $line;
          }
        }
      }

      if ($lines != ''){
        echo $lines;
      } else 
        echo $inner . implode($glue, $block->lines);

      if (!$isSingle && !empty($block->children)) {
        echo $this->break;
      }
    }

    foreach ($block->children as $child) {
      $this->block($child);
    }

    if (!empty($block->selectors)) {
      if (!$isSingle && empty($block->children))
        echo $this->break;

      if ($isSingle) {
        echo $this->closeSingle . $this->break;
      } else {
        echo $pre . $this->close . $this->break;
      }

      $this->indentLevel--;
    }
  }

}

class art_lessc_formatter_compressed extends art_lessc_formatter_classic {

  public $disableSingle = true;
  public $open = "{";
  public $selectorSeparator = ",";
  public $assignSeparator = ":";
  public $break = "";
  public $compressColors = true;

  public function indentStr($n = 0) {
    return "";
  }

}

class art_lessc_formatter_lessjs extends art_lessc_formatter_classic {

  public $disableSingle = true;
  public $breakSelectors = true;
  public $assignSeparator = ": ";
  public $selectorSeparator = ",";

}
