<?php

/**
 * lessCompileTask kompilacja plików poprzez cli symfoni.
 *
 * @package    artLESSPlugin
 * @subpackage lib

 * @version    1.0.0
 */
class lessCompileTask extends sfBaseTask {

  /**
   * Konfiguracja Taska
   */
  protected function configure() {
    $this->addArguments(array(
        new sfCommandArgument('file', sfCommandArgument::OPTIONAL, 'Plik less do kompilacji.')
    ));

    $this->addOptions(array(
        new sfCommandOption(
                'application', null, sfCommandOption::PARAMETER_OPTIONAL, 'Nazwa aplikacji'
        ),
        new sfCommandOption(
                'env', null, sfCommandOption::PARAMETER_REQUIRED, 'Środowisko ( np. dev, prod, test)', 'prod'
        ),
        new sfCommandOption(
                'clean', null, sfCommandOption::PARAMETER_NONE, 'Usuwanie wszystkich skompilowanych plików, przed kompilacją.'
        ),
        new sfCommandOption(
                'compress', null, sfCommandOption::PARAMETER_NONE, 'Kompresja utworzonego pliku.'
        ),
        new sfCommandOption(
                'debug', null, sfCommandOption::PARAMETER_NONE, 'Wyświetlanie komunikatów debugera'
        )
    ));

    $this->aliases = array("lc");
    $this->namespace = 'less';
    $this->name = 'compile';
    
    $this->briefDescription = 'Kompiluje pliki LESS (znajdujące się w katalogu /web/less) do katalogu web/css.
     Nazwy plików bedą takie same. Pliki o tych samych nazwach zostaną nadpisane';
    $this->detailedDescription = <<<EOF
    Task [less:compile|INFO] ompiluje pliki LESS (znajdujące się w katalogu /web/less) do katalogu web/css.
         Nazwy plików bedą takie same. Pliki o tych samych nazwach zostaną nadpisane.

    Przykład użycia:

      [php symfony less:compile|INFO]
EOF;
    
  }

  /**
   * Task, wykonanie.
   */
  protected function execute($arguments = array(), $options = array()) {
    // Tworzenie instancji klasy, konfiguracja
    $less = new artLESS(new artYamlLESSConfig(
            false, isset($options['compress']) && $options['compress']
    ));

    // Usuwanie starych plikow CSS opcja --clean
    if (isset($options['clean']) && $options['clean']) {
      foreach ($less->findCssFiles() as $cssFile) {
        if (!isset($arguments['file']) || (false !== strpos($cssFile, $arguments['file'] . '.css'))) {
          unlink($cssFile);
          $this->logSection(
                  'removed', str_replace(artLESS::getConfig()->getCssPaths(), '', $cssFile)
          );
        }
      }
    }

    // Wyświetlanie komunikatów debugera
    if (isset($options['debug']) && $options['debug']) {
      foreach (artLESS::getConfig()->getDebugInfo() as $key => $value) {
        $this->logSection('debug', sprintf("%s:\t%s", $key, $value), null, 'INFO');
      }
    }

    // Kompilacja
    foreach ($less->findLessFiles() as $lessFile) {
      if (!isset($arguments['file']) || (false !== strpos($lessFile, $arguments['file'] . '.less'))) {
        if ($less->compile($lessFile)) {
          if (isset($options['debug']) && $options['debug']) {
            $this->logSection('skompilowano', sprintf("%s => %s", artLESSUtils::getProjectRelativePath($lessFile), artLESSUtils::getProjectRelativePath($less->getCssPathOfLess($lessFile))
                    ), null, 'COMMAND');
          } else {
            $this->logSection(
                    'compiled+', $lessFile, null, 'COMMAND'
            );
            
            $lessFile = str_replace('.less', '.css', $lessFile); 
            
            $this->logSection(
                    'file+', str_replace('less','css', $lessFile), null, 'COMMAND'
            );
          }
        }
      }
    }
  }
}
