<?php
/**
 * Klasa bazowa do generowania opakowań HTML. ArtBoxów.
 */

class artBaseBox
{
    const staticBox = 'box_full';

    const topLeft = 'box_top_left';
    const topCenter = 'box_top_center';
    const topRight = 'box_top_right';

    const middleLeft = 'box_middle_left';
    const middleCenter = 'box_middle_center';
    const middleRight = 'box_middle_right';

    const bottomLeft = 'box_bottom_left';
    const bottomCenter = 'box_bottom_center';
    const bottomRight = 'box_bottom_right';

    const left = "box_left";
    const right = "box_right";
    const top = "box_top";
    const bottom = "box_bottom";

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function topLeftBox($class = self::topLeft, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function topCenterBox($class = self::topCenter, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class = self::topCenter, $options = '');
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function topRightBox($class = self::topRight, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function middleLeftBox($class = self::middleLeft, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function middleCenterBox($class = self::middleCenter, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function middleRightBox($class = self::middleRight, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function bottomLeftBox($class = self::bottomLeft, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function bottomCenterBox($class = self::bottomCenter, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function bottomRightBox($class = self::bottomRight, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param $class
     * @param string $options
     * @return string
     */
    public static function leftBox($class = self::leftCenter, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param $class
     * @param string $options
     * @return string
     */
    public static function rightBox($class = self::rightCenter, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }

    /**
     * @param string $class
     * @param string $options
     * @return string
     */
    public static function staticBox($class = self::staticBox, $options = '')
    {
        return artHtmlHelper::getBeginDiv($class, $options);
    }
}

?>
