<?php
/**
 * Klasa do generowania opakowań HTML. ArtBoxów.
 *
 */

class artBox extends artBaseBox
{

    /**
     * @param string $type
     * @param string $content
     * @return string
     */
    public static function getInlineBox($type = 'dynamic', $content = '')
    {
        return self::beginInlineBox($type) . $content . self::endInlineBox($type);
    }

    /**
     * @param string $type
     * @return mixed
     */
    public static function beginInlineBox($type = 'dynamic')
    {
        return str_replace("\n", "", self::beginBox($type));
    }

    /**
     * @param string $type
     * @return mixed
     */
    public static function endInlineBox($type = 'dynamic')
    {
        return str_replace("\n", "", self::endBox($type));
    }

    /**
     * @param string $type
     * @param string $content
     * @return string
     */
    public static function getBox($type = 'dynamic', $content = '')
    {
        switch ($type) {
            case 'horizontal' :
                $result = self::beginHorizontalBox() . $content . self::endHorizontalBox();
                break;
            case 'vertical' :
                $result = self::beginVerticalBox() . $content . self::endVerticalBox();
                break;
            case 'horizontal_span' :
                $result = self::beginHorizontalBox('span') . $content . self::endHorizontalBox('span');
                break;
            case 'vertical_span' :
                $result = self::beginVerticalBox('span') . $content . self::endVerticalBox('span');
                break;
            case 'static' :
                $result = self::beginStaticBox() . $content . self::endStaticBox();
                break;
            case 'dynamic':
                $result = self::beginDynamicBox() . $content . self::endDynamicBox();
                break;
            case 'dynamic_div':
                $result = self::beginDynamicDivBox() . $content . self::endDynamicDivBox();
                break;
            default:
                $result = self::beginDynamicBox() . $content . self::endDynamicBox();
                break;
        }
        return $result;
    }

    /**
     * @param string $type
     * @param string $class
     * @return string
     */
    public static function beginBox($type = 'dynamic', $class = '')
    {
        switch ($type) {
            case 'horizontal' :
                $result = self::beginHorizontalBox();
                break;
            case 'vertical' :
                $result = self::beginVerticalBox();
                break;
            case 'horizontal_span' :
                $result = self::beginHorizontalBox('span');
                break;
            case 'vertical_span' :
                $result = self::beginVerticalBox('span');
                break;
            case 'static' :
                $result = self::beginStaticBox();
                break;
            case 'dynamic':
                $result = self::beginDynamicBox($class);
                break;
            case 'dynamic_div':
                $result = self::beginDynamicDivBox();
                break;
            case 'dynamic_span':
                $result = self::beginDynamicSpanBox();
                break;
            default:
                $result = self::beginDynamicBox($class);
                break;
        }
        return $result;
    }

    /**
     * @param string $type
     * @return null|string
     */
    public static function endBox($type = 'dynamic')
    {
        switch ($type) {
            case 'horizontal' :
                $result = self::endHorizontalBox();
                break;
            case 'vertical' :
                $result = self::endVerticalBox();
                break;
            case 'horizontal_span' :
                $result = self::endHorizontalBox('span');
                break;
            case 'vertical_span' :
                $result = self::endVerticalBox('span');
                break;
            case 'static' :
                $result = self::endStaticBox();
                break;
            case 'dynamic':
                $result = self::endDynamicBox();
                break;
            case 'dynamic_div':
                $result = self::endDynamicDivBox();
                break;
            case 'dynamic_span':
                $result = self::endDynamicSpanBox();
                break;
            default:
                $result = self::endDynamicBox();
                break;
        }
        return $result;
    }

    /**
     * @param string $param
     * @return string
     */
    private static function beginHorizontalBox($param = 'div')
    {
        $result = '<' . $param . ' class="box_left"></' . $param . '><' . $param . ' class="box_center">';
        return $result;
    }

    /**
     * @param string $param
     * @return string
     */
    private static function endHorizontalBox($param = 'div')
    {
        $result = '</' . $param . '><' . $param . ' class="box_right"></' . $param . '>';
        return $result;
    }

    /**
     * @param string $param
     * @return string
     */
    private static function beginVerticalBox($param = 'div')
    {
        $result = '<' . $param . ' class="box_top"></' . $param . '><' . $param . ' class="box_middle">';
        return $result;
    }

    /**
     * @param string $param
     * @return string
     */
    private static function endVerticalBox($param = 'div')
    {
        $result = '</' . $param . '><' . $param . ' class="box_bottom"></' . $param . '>';
        return $result;
    }

    /**
     * @return mixed
     */
    private static function beginStaticBox()
    {
        $result = self::beginStaticBox();
        return $result;
    }

    /**
     * @return string
     */
    private static function endStaticBox()
    {
        return artHtmlHelper::getEndDiv();
    }

    /**
     * @param $class
     * @return string
     */
    private static function beginDynamicBox($class  = 'table')
    {
        $result = '
	  <table class="' . $class . '" border="0" cellpadding="0" cellspacing="0">
		<tr>
			<td class="box_top_left"></td>
			<td class="box_top_center"></td>
			<td class="box_top_right"></td>
		</tr>
		<tr>
			<td class="box_middle_left"></td>
			<td class="box_middle_center">';

        return $result;
    }

    /**
     * @return string
     */
    private static function endDynamicBox()
    {
        $result = '</td>
			<td class="box_middle_right"></td>
		</tr>
		<tr>
			<td class="box_bottom_left"></td>
			<td class="box_bottom_center"></td>
			<td class="box_bottom_right"></td>
		</tr>
	 </table>';
        return $result;
    }

    /**
     * @return string
     */
    public static function beginDynamicDivBox()
    {
        $result = self::middleLeftBox();
        $result .= self::middleRightBox();
        $result .= self::TopRightBox();
        $result .= self::topCenterBox();
        $result .= self::bottomCenterBox();
        $result .= self::topLeftBox();
        $result .= self::bottomLeftBox();
        $result .= self::bottomRightBox();
        $result .= self::topRightBox();

        return $result;
    }

    /**
     * @return string
     */
    public static function beginDynamicSpanBox()
    {
        $result = '<span class="box_top art-auto-height">
                 <span class="box_top_left art-left"></span>
                 <span class="box_top_center art-left"></span>
                 <span class="box_top_right art-left"></span>
               </span>
               <span class="box_middle art-auto-height">
                 <span class="box_middle_left art-left"></span>
                 <span class="box_middle_center art-left">';

        return $result;
    }

    /**
     * @return string
     */
    public static function endDynamicSpanBox()
    {
        $result = '</span>
               <span class="box_middle_right art-left"></span>
             </span>
             <span class="box_bottom art-auto-height">
               <span class="box_bottom_left art-left"></span>
               <span class="box_bottom_center art-left"></span>
               <span class="box_bottom_right art-left"></span>
             </span>';

        return $result;
    }

    /**
     * @return null|string
     */
    private static function endDynamicDivBox()
    {
        $result = null;
        for ($i = 0; $i < 9; $i++)
            $result .= artHtmlHelper::getEndDiv();

        return $result;
    }

}
