<?php
/**
 * View Helper to echo some html tag
 */

class artHtmlHelper
{
    /**
     * Function returns text and translated title in given div classes
     * @param string $title
     * @param string $text
     * @param string $titleDiv
     * @param string $textDiv
     * @param boolean $foreach should data be aquired by foreach loop
     * @return string
     */
    public static function getTitleText($title, $text, $titleDiv, $textDiv, $foreach = false)
    {
        if ($foreach) {
            $string = '';
            $flag = true;
            foreach ($text as $data) {
                if ($flag) $flag = false;
                else $string .= ', ';
                $string .= $data->getName();
            }
            $text = $string;
        }
        return '<div class="' . $titleDiv . '">' . __($title) . '</div><div class="' . $textDiv . '">' . $text . '</div>';
    }

    /**
     * Function returns translated text wrapped in given div
     * @param string $text
     * @param string $div
     * @return string
     */
    public static function getSection($text, $div)
    {
        return '<div class="' . $div . '">' . __($text) . '</div>';
    }

    /**
     * Function returns from to in given div classes
     * @param string $from
     * @param string $to
     * @param string $fromtoDiv
     * @param string $textDiv
     * @return string
     */
    public static function getFromTo($from, $to, $fromtoDiv, $textDiv)
    {
        return '<div class="' . $fromtoDiv . '">' . __('From') . '</div><div class="' . $textDiv . '">' . $from . '</div>' .
            '<div class="' . $fromtoDiv . '">' . __('To') . '</div><div class="' . $textDiv . '">' . $to . '</div>';
    }

    /**
     * Get begin div tag
     * @param string $class
     * @param array $options
     * @return string
     */
    public static function getBeginDiv($class, $options)
    {
        $options['class'] = $class;
        return tag('div', $options, true);
    }

    /**
     * Get End div tag
     * @return string
     */
    public static function getEndDiv()
    {
        return artString::getEndTag('div');
    }

    /**
     * get a tag begin
     * @param string $class
     * @param array $options
     * @return string
     */
    public static function getBeginA($class, $options)
    {
        sfContext::getInstance()->getConfiguration()->loadHelpers(array('Tag'));
        $options['class'] = $class;
        return tag('a', $options, true);
    }

    /**
     * get end tag a
     * @return string
     */
    public static function getEndA()
    {
        return artString::getEndTag('a');
    }

    /**
     * @param $array
     * @param $class
     */
    public static function addHtmlClassToArray(&$array, $class)
    {
        if (isset($array['class']))
            $array['class'] .= ' ' . $class;
        else
            $array['class'] = $class;
    }
}
