<?php
class artDate
{

    /**
     * Zwraca datę z polskimi nazwami dni i miesięcy;
     *
     * @param $format
     * @param null $timestamp
     * @return bool|string
     */
    public static function polishDate($format, $timestamp = null)
    {
        $to_convert = array(
            'l' => array('dat' => 'N', 'str' => array(_('Poniedziałek'), _('Wtorek'), _('Środa'), _('Czwartek'), _('Piątek'), _('Sobota'), _('Niedziela'))),
            'F' => array('dat' => 'n', 'str' => array(_('styczeń'), _('luty'), _('marzec'), _('kwiecień'), _('maj'), _('czerwiec'), _('lipiec'), _('sierpień'), _('wrzesień'), _('październik'), _('listopad'), _('grudzień'))),
            'f' => array('dat' => 'n', 'str' => array(_('stycznia'), _('lutego'), _('marca'), _('kwietnia'), _('maja'), _('czerwca'), _('lipca'), _('sierpnia'), _('września'), _('października'), _('listopada'), _('grudnia')))
        );

        if ($timestamp === null) {
            $timestamp = time();
        }

        $pieces = preg_split('#[:/.\-, ]#', $format);

        if ($pieces) {
            foreach ($pieces as $datepart) {
                if (array_key_exists($datepart, $to_convert)) {
                    $replace[] = $to_convert[$datepart]['str'][(date($to_convert[$datepart]['dat'], $timestamp) - 1)];
                } else {
                    $replace[] = date($datepart, $timestamp);
                }
            }

            $arr = array_combine($pieces, $replace);

            foreach ($arr as $key => $val) {
                if (empty($key)) {
                    $key = ' ';
                }

                if (empty($val)) {
                    $val = ' ';
                }

                $arr2[$key] = $val;
            }

            return strtr($format, $arr2);
        }

        return false;
    }

    /**
     * Return y-m-d H:i:s of today time
     *
     * @return date
     */
    public static function today($date = null, $dateFormat = "Y-m-d H:i:s")
    {
        return date($dateFormat, is_null($date) ? time() : $date);
    }

    /**
     * return day date in next week
     */
    public static function getLastWeekDate()
    {
        $lastWeek = mktime(0, 0, 0, date("m"), date("d") - 7, date("Y"));
        return self::today($lastWeek);
    }

    /**
     * Return minus given year
     * @param int $year
     * @return date
     */
    public static function getYearBefore($year)
    {
        $lastWeek = mktime(0, 0, 0, date("m"), date("d"), date("Y") - $year);
        return self::today($lastWeek);
    }

    public static function getYearAfter($year)
    {
        $lastWeek = mktime(0, 0, 0, date("m"), date("d"), date("Y") + $year);
        return self::today($lastWeek);
    }

    /**
     * return date last @param $days
     * @param int $days
     */
    public static function getBeforeDate($days)
    {
        return date("Y-m-d H:i:s", time() - (($days) * 24 * 3600));
    }

    /**
     *
     * Return date from datetime Y-m-d H:i:s => y-m-d
     * @param <type> $date
     * @return <type>
     */
    public static function datetimeWithoutHour($date)
    {
        $pom = explode(' ', $date);
        return $pom[0];
    }

    public static function nameOfDay($date)
    {
        $date = self::datetimeWithoutHour($date);
        $pom1 = explode('-', $date);
        $day = date("l", mktime(0, 0, 0, $pom1[1], $pom1[2], $pom1[0]));
        return $day;
    }

    /**
     * return timestamp
     * @param DATE $dateArray
     * @return timestamp day
     */
    public static function mkTimeFromDate($dateArray)
    {
        return mktime($dateArray['hour'], $dateArray['minute'], $dateArray['second'], $dateArray['month'], $dateArray['day'], $dateArray['year']);
    }

    /**
     * return timestamp today
     * @return timestamp day
     */
    public static function mkTimeToday()
    {
        $todayArray = date_parse(artDate::today());
        return self::mkTimeFromDate($todayArray);
    }

    /**
     *
     * @param <type> $date null = today
     * @param <type> $sec
     * @param <type> $min
     * @param <type> $hour
     * @param <type> $day
     * @param <type> $month
     * @param <type> $year
     * @return <type>
     */
    public static function getNextDate($date = null, $sec = 0, $min = 0, $hour = 0, $day = 0, $month = 0, $year = 0, $dateFormat = "Y-m-d H:i:s", $set_sec = 0, $set_min = 0, $set_hour = 0, $set_day = 0, $set_month = 0, $set_year = 0)
    {
        if (is_null($date))
            $date = date_parse(self::today());
        else
            $date = date_parse($date);
        if ($set_sec != 0)
            $date['second'] = $set_sec;
        if ($set_min != 0)
            $date['minute'] = $set_min;
        if ($set_hour != 0)
            $date['hour'] = $set_hour;
        if ($set_day != 0)
            $date['day'] = $set_day;
        if ($set_month != 0)
            $date['month'] = $set_month;
        if ($set_year != 0)
            $date['year'] = $set_year;

        $lastWeek = mktime($date['hour'] + $hour, $date['minute'] + $min, $date['second'] + $sec, $date['month'] + $month, $date['day'] + $day, $date['year'] + $year);

        return self::today($lastWeek, $dateFormat);
    }

    /**
     * @param null $date
     * @param string $dateFormat
     * @return date
     */
    public static function getNextDay($date = null, $dateFormat = "Y-m-d H:i:s")
    {
        return self::getNextDate($date, 0, 0, 0, 1, 0, 0, $dateFormat);
    }

    /**
     * @param null $date
     * @param string $dateFormat
     * @return date
     */
    public static function getDayBefore($date = null, $dateFormat = "Y-m-d H:i:s")
    {
        return self::getNextDate($date, 0, 0, 0, -1, 0, 0, $dateFormat);
    }

    /**
     * @param $year
     * @param string $culture
     * @return array
     */
    public static function getHolidays($year, $culture = 'pl')
    {
        $easter = date("Y-m-d", easter_date($year));
        $easter2 = date('Y-m-d', strtotime('+1 day', strtotime($easter)));
        $zds = date('Y-m-d', strtotime('+49 day', strtotime($easter)));
        $bc = date('Y-m-d', strtotime('+60 day', strtotime($easter)));

        $holiday = array();

        $day = strtotime($year . '-01-01');

        while (date('Y', $day) == $year) {
            if (date('w', $day) == 6)
                $holiday[date('Y-m-d', $day)] = $culture == 'pl' ? 'sobota' : 'saturday';
            if (date('w', $day) == 0)
                $holiday[date('Y-m-d', $day)] = $culture == 'pl' ? 'niedziela' : 'sunday';

            $day += 24 * 60 * 60;
        }

        $holiday[$year . '-01-01'] = $culture == 'pl' ? 'Nowy Rok' : "New Year's Day";
        $holiday[$year . '-01-06'] = $culture == 'pl' ? 'Święto Trzech Króli' : 'Three Kings Day';
        $holiday[$easter] = $culture == 'pl' ? 'Wielkanoc' : 'Easter Eve';
        $holiday[$easter2] = $culture == 'pl' ? 'Poniedziałek Wielkanocny' : 'Easter Monday';
        $holiday[$year . '-05-01'] = $culture == 'pl' ? 'Święto Pracy' : 'Labour Day';
        $holiday[$year . '-05-03'] = $culture == 'pl' ? 'Święto Konstytucji 3 Maja' : 'The Constitution Day';
        $holiday[$zds] = $culture == 'pl' ? 'Zesłanie Ducha Świętego (Zielone Świątki)' : 'Pentecost';
        $holiday[$bc] = $culture == 'pl' ? 'Boże Ciało' : 'Corpus Christi';
        $holiday[$year . '-08-15'] = $culture == 'pl' ? 'Wniebowzięcie Najświętszej Maryi Panny' : 'Assuption Day';
        $holiday[$year . '-11-01'] = $culture == 'pl' ? 'Wszystkich Świętych' : 'All Saints Day';
        $holiday[$year . '-11-11'] = $culture == 'pl' ? 'Święto Niepodległości' : 'Independence Day';
        $holiday[$year . '-12-25'] = $culture == 'pl' ? 'Boże Narodzenie (pierwszy dzień)' : 'Christmas Day';
        $holiday[$year . '-12-26'] = $culture == 'pl' ? 'Boże Narodzenie (drugi dzień)' : 'Boxing Day';

        ksort($holiday);

        return $holiday;
    }

    /**
     * @param $dateString
     * @param string $dateFormat
     * @return string
     */
    public static function getDateInOtherFormat($dateString, $dateFormat = 'd.m.Y')
    {
        return date($dateFormat, strtotime($dateString));
    }
}
