<?php
/**
 * Klasa obsługująca format daty.
 */

class artFormatDate extends artDate
{
    public static $ERROR_NOT_SET = 'Date not set';

    /**
     * @param date $date
     * @return Y-m-d
     */
    public static function getFormatYmd($date)
    {
        return date('Y-m-d', strtotime($date));
    }

    /**
     * @param date $date
     * @param withCheck
     * @return Y-m-d
     */
    public static function getFormatYmdHm($date, $withCheck = false)
    {
        if ($withCheck) {
            return ($date !== false && $date > 0) ? artFormatDate::getFormatYmdHm($date) : self::translateErrorNotSet();
        } else
            return date('Y-m-d H:m', strtotime($date));
    }

    /**
     * @return string
     */
    public static function translateErrorNotSet()
    {
        return sfContext::getInstance()->getI18N()->__(self::$ERROR_NOT_SET);
    }
}