<?php
/**
 * Klasa do obsługi plików.
 *
 
 */

class artFile
{
    /**
     * Funkcja przenosi plik $filename do $destination, gdzie $destination zawiera nazwę pliku docelowego
     *
     * @param type $filename
     * @param type $destination
     * @param type $moveUploadedFile jeżeli true, to wykonywana jest funkcja move_uploaded_file, w przeciwnym wypadku
     * sprawdzane jest, czy przenoszony plik znajduje sie w site/web
     */
    public static function moveFile($filename, $destination, $moveUploadedFile = false)
    {
        if ($moveUploadedFile || strpos($filename, sfConfig::get('sf_web_dir')) === 0) {
            if ($moveUploadedFile)
                move_uploaded_file($filename, $destination);
            else
                rename($filename, $destination);

            chmod($destination, 0777);
        }
    }

    /**
     * Zwraca typ mime pliku.
     *
     * @param $file
     * @return bool|string
     */
    public static function guessMimeTypeFromFileinfo($file)
    {
        if (!function_exists('finfo_open') || !is_readable($file))
            return false;

        if (!$finfo = new finfo(FILEINFO_MIME))
            return false;

        $type = $finfo->file($file);

        if (false !== $pos = strpos($type, ';'))
            $type = substr($type, 0, $pos);

        return $type;
    }
}
