<?php
/**
 * Klasa do obsługi plików.
 *
 
 */

class artFilePath
{

    /**
     * Sprawdza czy plik istnieje w folderze upload.
     * @param $path
     * @return bool
     */
    public static function isFileExistsInUploads($path)
    {
        return self::isFileExists(sfConfig::get('sf_upload_dir') . $path);
    }

    /**
     * Sprawdza czy plik istnieje.
     *
     * @param $path
     * @return bool
     */
    public static function isFileExists($path)
    {
        return file_exists($path);
    }

    /**
     * Dodaje sufix przed nazwą pliku.
     *
     * @param string $string filename path
     * @param string $name suffix to add
     */
    public static function addSuffixFileName($string, $name)
    {
        $fileLength = strlen($string);
        $lastDotPosition = strripos($string, '.');
        $filePathToLastDot = substr($string, 0, $lastDotPosition);
        $fileExtension = substr($string, -$lastDotPosition + $fileLength + 1);

        $newFilePath = $filePathToLastDot . $name . $fileExtension;

        return $newFilePath;
    }

    /**
     * Sprawdza czy folder istnieje.
     *
     * @see artFilePAth::isFileExists
     * @param string $path
     * @return bool
     */
    public static function isFolderExist($path)
    {
        return self::isFileExists($path);
    }

    /**
     * Zwraca nazwy plików z podanego folderu.
     *
     * @param string $path
     * @param string $myext default png,jpg, jpeg
     * @param bool $ok true= return AssocArray
     * @return Array
     */
    public static function allNamesFromFolder($path, $possibleExtensions = array('png', 'jpeg', 'jpg'), $returnAssocArray = true)
    {
        $filesList = opendir($path);
        $names = array();

        if (is_string($possibleExtensions))
            $possibleExtensions = array($possibleExtensions);

        while (($file = readdir($filesList)) !== false) {
            $isFile = ($file != '.') && ($file != '..') && ($file != '.svn') && ($file != basename($_SERVER['PHP_SELF'])) && (!is_dir($path . $file));

            if ($isFile) {
                if (empty($possibleExtensions))
                    $names[$file] = $file;
                else {
                    $tab = explode('.', $file);
                    $ext = end($tab);

                    if (in_array($ext, $possibleExtensions))
                        $names[$file] = $file;
                }
            }
        }
        closedir($filesList);

        if (empty($names))
            return array();
        else if ($returnAssocArray)
            return $names;
        else {
            $files = array();

            foreach ($names as $id => $value)
                $files[] = $value;

            return $files;
        }
    }

}
