<?php
/**
 * Filtr łączący requesty do plików js i css w dwa wywyłania pliku combine.php
 */

class artCombineFilter extends sfFilter
{

  public function execute($filterChain)
  {
    $filterChain->execute();
    $response = $this->context->getResponse();

    // include stylesheets
    $content = $response->getContent();

    if (false !== ($pos = strpos($content, '<head>')))
    {
      $this->context->getConfiguration()->loadHelpers(array('Tag', 'Asset'));
      $html = '';

      if (!sfConfig::get('symfony.asset.stylesheets_included', false))
      {
        $css = get_stylesheets($response);
        $staticContentDomain = sfConfig::get('app_staticcontentdomain','');
        if ($staticContentDomain != '')
        {
          if ($this->context->getRequest()->isSecure())
            $staticContentDomain = 'https://'.$staticContentDomain;
          else 
            $staticContentDomain = 'http://'.$staticContentDomain;
        }
        
        $p2 = 0;
        $html2 = '';

        if ($css)
        {
          do
          {
            //znajde pliki
            $p1 = strpos($css, 'href="', $p2);
            if ($p1 > 0)
            {
              $p2 = strpos($css, '"', $p1 + 6);

              if ($p1 > 0 & $p2 > 0)
              {
                $file = substr($css, $p1 + 6, $p2 - $p1 - 6);

                if ($html == '')
                  $html = '<link rel="stylesheet" type="text/css" media="screen" href="'.$staticContentDomain.'/combine.php?type=css&amp;files=';
                else
                  $html.=',';
                $html .= $file;
              }
              else
                $p2= - 1;
            }
            else
              $p2= - 1;
          }
          while ($p2 > 0);

          $html .='" />'; //.$html2;	
        }

        if ($html)
          $response->setContent(substr($content, 0, $pos+6) . $html . substr($content, $pos+6));
      }
    }

    // include javascripts
    $content = $response->getContent();

    if (false !== ($pos = strpos($content, '</head>')))
    {
      $this->context->getConfiguration()->loadHelpers(array('Tag', 'Asset'));
      $html = '';

      if (!sfConfig::get('symfony.asset.javascripts_included', false))
      {
        $css = get_javascripts($response);
        $html2 = '';
        $htmljq = '';
        $p2 = 0;
        $p1 = 0;

        if ($css)
        {
          do
          {
            //znajde pliki
            $p1 = strpos($css, 'src="', $p2);
            if ($p1 > 0)
            {
              $p2 = strpos($css, '"', $p1 + 5);

              if ($p1 > 0 & $p2 > 0)
              {
                $file = substr($css, $p1 + 5, $p2 - $p1 - 5);

                if ($html == '')
                  $html = '<script type="text/javascript" src="'.$staticContentDomain.'/combine.php?type=js&amp;files=';
                else
                  $html.=',';
                $html .= $file;
              }
              else
                $p2= - 1;
            }
            else
              $p2= - 1;
          }
          while ($p2 > 0);

          if ($html)
            $html .='"></script>';
        }

        //$html= get_javascripts($response); //.
        /* foreach ($response->getJavascripts() as $file => $options)
          {
          if ($html=='') $html = '<script type="text/javascript" src="/js/';
          else $html.=',';
          $html .= $file;
          }
          $html .='"></script>';
         */
        if ($html)
        {
          $response->setContent(substr($content, 0, $pos) . $html . substr($content, $pos));
        }
      }
    }

    sfConfig::set('symfony.asset.javascripts_included', false);
    sfConfig::set('symfony.asset.stylesheets_included', false);
  }

}

?>