<?php 

class sslFilter extends sfFilter{
 
    /**
     * executes the filter.  This filter will determine if a
     * request should be http or https and will redirect as such
     * 
     * @param sfFilterChain $filterChain the current symfony filter chain
     * @return boolean redirect status 
     */
    public function execute( $filterChain ){
        //only run once per request
		$this->logInfo("########### SSL FILTER STARTED#####################");
        if( $this->isFirstCall() ){
			$this->logInfo("is first Call");
            $request = $this->getContext()->getRequest();			
            //only filter is the request is get or head
            if( $request->isMethod( 'get' ) || $request->isMethod( 'head' ) ){
				$this->logInfo("is get or post");
				if ($this->getContext()->getUser()->isAuthenticated()){
					$this->logInfo("is authenticaded");
					if( !$request->isSecure() ){
						$this->logInfo("is not secure");
						return $this->redirectSecure( $request );
					}
				}else{
					$this->logInfo("is not authenticated");
					$controller = $this->getContext()->getController();
					$stackEntry = $controller->getActionStack()->getLastEntry();
					$module = $stackEntry->getModuleName();
					$action = $stackEntry->getActionName();
					//get the module settings
					$moduleSettings = sfConfig::get( 'app_ssl_secure', false );
					
					//see if strict settings are on (non secure modules must be http)
					$strict = sfConfig::get( 'app_ssl_strict', true );
					//if there are settings for this module
				//	print_r($moduleSettings);
				//	echo $module;
				//	echo $action;
				    $this->logInfo ("start".$module." / ".$action." url=".$request->getUri());
					if( isset( $moduleSettings[$module] ) ){
						$this->logInfo("is in module list");
						//$strict = ( isset( $moduleSettings[ 'strict' ] ) && $moduleSettings[ 'strict' ] ) ? true:false;
						//there are actions defined, check if this actions is secure
						if( isset( $moduleSettings[ $module ][ 'actions' ] ) ){
							$this->logInfo("module has actions");
							//this is a secure action
							if( !$request->isSecure() &&
								is_array( $moduleSettings[ $module ][ 'actions' ] ) &&
								in_array($action, $moduleSettings[ $module ][ 'actions' ])
							){
								$this->logInfo("is in actions");
	 
								//we need to redirect to a secure url
								return $this->redirectSecure( $request );
							}//else: the request should be secure, and is. No more to be done.
						//module was defined, but no actions were
						}else if( !$request->isSecure() ){
							$this->logInfo("no actions in module - and not secure");
							//every action in this module is secure, redirect
							return $this->redirectSecure( $request );
						}
					}else 
					{//print_r($moduleSettings);
					$this->logInfo("no module");
						if( $request->isSecure() && $strict ){
						$this->logInfo("is secure");
						//redirect back to http, strict is set
						return $this->redirectUnsecure( $request );
					}}
				}
            }
        }
        //no redirect necessary, continue the filter chain
        $filterChain->execute();
    }
	/**
     * Sends info to logger
     * 
     * @param string $info
     * 
     */
	protected function logInfo($info){
	if (sfConfig::get('sf_logging_enabled'))
				{
				  sfContext::getInstance()->getLogger()->info($info);
				}
	}
    /**
     * redirects an http request to https
     * 
     * @param sfWebRequest $request
     * @return boolean
     */
    protected function redirectSecure( $request ){
        //replace http w/ https		
        $url = str_replace( 'http', 'https', $request->getUri() );
//		echo $url;
				$this->logInfo("Secure: changed to url=".$url);
		
        //return $this->getContext()->getController()->redirect( $url, 0, 301 );
		return $this->redirectNoCache( $url, 0, 301 );
    }
 
    /**
     * redirects an https request to http
     *
     * @param sfWebRequest $request
     * @return boolean
     */
    protected function redirectUnsecure( $request ){
        //replace https w/ http
	
		
        $url = str_replace( 'https', 'http', $request->getUri() );
	$this->logInfo("Unsecure:changed to url=".$url);
        return $this->redirectNoCache( $url, 0, 301 );
    }
	protected function redirectNoCache($url, $delay = 0, $statusCode = 302)
	{
	//  return $this->getContext()->getController()->redirect( $url, 0, 301 );
	    if (empty($url))
	    {
	      throw new InvalidArgumentException('Cannot redirect to an empty URL.');
	    }
	
	    $this->getContext()->getUser()->forwardNotice();
	    $this->getContext()->getUser()->forwardError();
	    
	    $url = $this->getContext()->getController()->genUrl($url, true);
	    // see #8083
	    $url = str_replace('&amp;', '&', $url);
	
	    // redirect
	    $response = $this->getContext()->getResponse();
	    $response->clearHttpHeaders();
	    $response->setStatusCode($statusCode);
	
	    // The Location header should only be used for status codes 201 and 3..
	    // For other code, only the refresh meta tag is used
	    if ($statusCode == 201 || ($statusCode >= 300 && $statusCode < 400))
	    {
	      $response->setHttpHeader('Location', $url);
	    }
		$response->addCacheControlHttpHeader('no-cache, must-revalidate, post-check=0, pre-check=0');		
	
	    $response->setContent(sprintf('<html><head><meta http-equiv="refresh" content="%d;url=%s"/></head></html>', $delay, htmlspecialchars($url, ENT_QUOTES, sfConfig::get('sf_charset'))));
	    $response->send();
	  
	}
}

?>