<?php

/**
 * Description of FileManagementForm
 *
 
 */
class FileManagementForm extends BaseFormDoctrine
{

    /**
     *
     */
    public function setup()
    {
        $this->disableRequiredsFieldText();
        $foreignKey = FileManagement::getForeignKeyName($this->getModel());
        $model = $this->getModel();

        $this->setWidgets(array(
            'id' => new sfWidgetFormInputHidden(),
            $foreignKey => new sfWidgetFormInputHidden(),
            'new_file' => new sfArtWidgetFormInputAjaxFile(),
            'icon' => new sfArtSelectImageWidget(array('images_dir' => FileManagement::getIconPath($model))),
            'order' => new sfWidgetFormInputHidden(),
        ));

        $this->setValidators(array(
            'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
            $foreignKey => new sfValidatorPass(),
            'new_file' => new sfValidatorFile(array(
                'path' => FileManagement::getFileAbsolutePath($this->getForeignKeyIdValue(), $model),
                'max_size' => FileManagement::getMaxSize($model)
            )),
            'icon' => new sfArtValidatorSelectImage(array('images_absolute_dir' => FileManagement::getIconAbsolutePath($model))),
            'order' => new sfValidatorInteger(array('required' => false)),
        ));

        $whiteList = FileManagement::getMimeTypesWhiteList($model);

        if (!empty($whiteList))
            $this->validatorSchema['new_file']->setOption('mime_types', $whiteList);

        $this->embedI18nWithLabels();
        $this->widgetSchema->setNameFormat('file[%s]');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    }

    public function getModel()
    {
        return $this->getOption('model', $this->getRequest()->getParameter('model'));
    }

    public function getForeignKeyIdValue()
    {
        return $this->getOption('fkIdValue', $this->getRequest()->getParameter('id'));
    }

    public function getModelName()
    {
        return $this->getModel();
    }

    public function save($con = null)
    {
        $file = $this->values['new_file'];
        $this->values['original_filename'] = $file->getOriginalName();
        $this->fkIdValue = $this->getForeignKeyIdValue();
        $this->model = $this->getModel();

        $this->renameFile();
        unset($this->values['new_file']);

        $object = parent::save($con);
        $originalPath = FileManagement::getFileAbsolutePath($this->fkIdValue, $this->model);
        $originalImagePath = FileManagement::getFileAbsolutePath($this->fkIdValue, $this->model, $object);

        if (!is_dir($originalPath))
            mkdir($originalPath, 0777, true);

        artFile::moveFile($file->getTempName(), $originalImagePath);

        return $object;
    }

    public function renameFile()
    {
        $extension = $this->values['new_file']->getOriginalExtension();

        if ($this->values[$this->getUserLang()]['title'] == '')
            $title = str_replace($extension, '', $this->values['new_file']->getOriginalName());
        else
            $title = $this->values[$this->getUserLang()]['title'];

        $this->values['file'] = Slug::slugify($title) . '_' . md5(time()) . $extension;
    }

}
