<?php

/**
 * Description of GalleryManagementForm
 *
 
 */
class GalleryManagementFrontendForm extends BaseFormDoctrine
{

  public function setup()
  {
    $this->disableRequiredsFieldText();
    
    $foreignKey = GalleryManagement::getForeignKeyName($this->getModel());

    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        $foreignKey => new sfWidgetFormInputHidden(),
        'image' => new sfArtWidgetFormInputAjaxFile(),
        'order' => new sfWidgetFormInputHidden(),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        $foreignKey => new sfValidatorPass(),
        'image' => new sfValidatorFile(array(
            'mime_types' => array('image/jpeg', 'image/pjpeg', 'image/png', 'image/x-png', 'image/gif'),
            'path' => GalleryManagement::getOriginalImageAbsolutePath($this->getForeignKeyIdValue(), $this->getModel()),
            'max_size' => GalleryManagement::getImageMaxSize($this->getModel())
        )),
        'order' => new sfValidatorInteger(array('required' => false)),
    ));

    $this->embedI18nWithLabels();
    $this->widgetSchema->setNameFormat('photo[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    
    $langs = sfConfig::get('sf_cultures', array('pl'));
    
    foreach ($langs as $lang)
    {

      unset($this->widgetSchema[$lang]['title']);
      unset($this->widgetSchema[$lang]['description']);
      unset($this->validatorSchema[$lang]['title']);
      unset($this->validatorSchema[$lang]['description']);

      $this->widgetSchema->setLabel($lang, false);
      
    }
    
  }

  public function getModel()
  {
    return $this->getOption('model', sfContext::getInstance()->getRequest()->getParameter('model'));
  }

  public function getForeignKeyIdValue()
  {
    return $this->getOption('fkIdValue', sfContext::getInstance()->getRequest()->getParameter('id'));
  }

  public function getModelName()
  {
    return $this->getModel();
  }

  public function save($con = null)
  {
    $image = $this->values['image'];
    $this->fkIdValue = $this->getForeignKeyIdValue();
    $this->model = $this->getModel();

    $this->renamePhotoFiles();
    unset($this->values['image']);

    $object = parent::save($con);
    $originalPath = GalleryManagement::getOriginalImageAbsolutePath($this->fkIdValue, $this->model);
    $originalImagePath = GalleryManagement::getOriginalImageAbsolutePath($this->fkIdValue, $this->model, $object);
    
    if (!is_dir($originalPath))
      mkdir($originalPath, 0777, true);
    
    artFile::moveFile($image->getTempName(), $originalImagePath);
    $this->resizePhotoFiles($originalImagePath);
    
    return $object;
  }

  public function resizePhotoFiles($originalImagePath)
  {
    foreach (array('small', 'medium', 'big') as $size)
    {
      $gmObject = GalleryManagement::getObject($this->model);
      $imageDir = sfConfig::get('sf_web_dir') . $gmObject->getImagePath($size, $this->fkIdValue);
      $imagePath = sfConfig::get('sf_web_dir') . $gmObject->getImagePath($size, $this->fkIdValue, $this->getObject());
      
      if (!is_dir($imageDir))
        mkdir($imageDir, 0777, true);
      
      $width = $gmObject->getImageOption($size, 'width', 50);
      $height = $gmObject->getImageOption($size, 'height', 50);
      
      $resizeCenter = $gmObject->getImageOption($size, 'resize_center', true);
      
      $plugins = sfContext::getInstance()->getConfiguration()->getPlugins();
      if (in_array('sfImageTransformPlugin',$plugins))
      {
        $img = new sfImage($originalImagePath);

        if ($resizeCenter)
          $img->thumbnail ($width,$height);
        else
          $img->thumbnail ($width,$height,'center');

        $img->saveAs ($imagePath);
      }else {      
        if ($resizeCenter)
          passthru("convert $originalImagePath -resize " .  $width . "x" . $height . "^ -gravity center -extent " . $width . "x" . $height . " $imagePath");
        else
          passthru("convert $originalImagePath -thumbnail " . $width . "x" . $height . " $imagePath");
      }
    }
  }
  
  public function renamePhotoFiles()
  {
    $extension = $this->values['image']->getOriginalExtension();
    
//    if ($this->values['pl']['title'] == '')
//      $title = str_replace($extension, '', $this->values['image']->getOriginalName());
//    else
//      $title = $this->values['pl']['title'];
    $title = "articlephoto";
    
    foreach (array('small', 'medium', 'big', 'original') as $size)
      $this->values[$size . '_image']  = Slug::slugify($title) . '_' . md5(time() . $size) . $extension;
  }

}
