<?php

/**
 * Formularz, konfiguracji.
 *
 * @package    ArtConfiguration
 */
abstract class PluginArtConfigurationForm extends BaseArtConfigurationForm {

    /**
     * Setup formularza.
     */
    public function setup() {
        $this->embedI18nWithLabels();
        $this->disableRequiredsFieldText();

        foreach ($this->getFormFieldSchema() as $name => $field) {
            if ($this->getWidget($name)->getAttribute('class', false)) {
                $this->getWidget($name)->setAttribute('class', $this->getWidget($name)->getAttribute('class') . ' form-control');
            } else {
                $this->getWidget($name)->setAttribute('class', 'form-control');
            }
        }

        $this->widgetSchema->setNameFormat('art_configuration[%s]');
        $this->getWidgetSchema()->setFormFormatterName('Flaty');

        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    }

    public function useTranslationFields() {
        return array('id', 'value');
    }

    public function save($con = null) {
        parent::save($con);
        $cache = $this->getContext()->getViewCacheManager();
        if ($cache) {
            $cache->remove('*');
        }
    }

    /**
     * Embeds i18n objects into the current form.
     * Nadpisana aby wlaczac tylko te pola ktore nas interesuja.
     * Pola zwracane przez funkcje useTranslationFields()
     *
     * @param array   $cultures   An array of cultures
     * @param string  $decorator  A HTML decorator for the embedded form
     */
    public function embedI18n($cultures, $decorator = null) {
        if (!$this->isI18n()) {
            throw new sfException(sprintf('The model "%s" is not internationalized.', $this->getModelName()));
        }

        $class = $this->getI18nFormClass();
        foreach ($cultures as $culture) {
            $i18nObject = $this->getObject()->Translation[$culture];
            $options = array();
            $options['widget'] = $this->getObject()->getWidget();
            $options['validator'] = $this->getObject()->getValidator();
            $i18n = new $class($i18nObject, $options);

            if (false === $i18nObject->exists()) {
                unset($i18n[$this->getI18nModelPrimaryKeyName()], $i18n[$this->getI18nModelI18nField()]);
            }

            $translationFields = $this->useTranslationFields();
            if (count($translationFields) > 0) {
                foreach ($i18n->getWidgetSchema()->getFields() as $name => $field) {
                    if (!in_array($name, $translationFields)) {
                        unset($i18n[$name]);
                    }
                }
            }

            $this->embedForm($culture, $i18n, $decorator);
        }
    }

}
