<?php

/**
 * PluginInvitation form.
 *
 * @package    ##PROJECT_NAME##
 * @author     ##AUTHOR_NAME##
 */
abstract class PluginInvitationForm extends BaseInvitationForm
{

  public function setup()
  {
    $this->setWidgets(array(
        'emails' => new sfArtWidgetFormEmailsTable()
    ));

    $this->setValidators(array(
        'emails' => new sfArtValidatorEmailsTable()
    ));

    $this->widgetSchema->setNameFormat('invitation[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }
  
  public function bind(array $taintedValues = null, array $taintedFiles = null)
  {
    $this->widgetSchema['emails']->setOption('inputs_count', count($taintedValues['emails']));
    
    parent::bind($taintedValues, $taintedFiles);
  }

  public function save($con = null)
  {
    Doctrine::getTable('Invitation')->deleteOldRecords();
    
    $inviter = $this->getUser()->getGuardUser();
    
    foreach ($this->values['emails'] as $email)
    {
      $invitationObject = new Invitation();
      $invitationObject->setInviterId($this->getUserId());
      $invitationObject->setEmail($email);
      $invitationObject->save();
      
      artSimpleMessenger::sendInvitationToServiceMessage($email, $inviter, $invitationObject);
    }
  }

}
