<?php

/**
 * PluginLayout form.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage form
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: sfDoctrineFormPluginTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
abstract class PluginLayoutForm extends BaseLayoutForm
{

  public function setup()
  {
    
    $this->setModuleName();
    
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'name' => new sfWidgetFormInputText(),
//        'view' => new sfWidgetFormInputText(),
        'html' => new sfWidgetFormTextarea(array(), array('class' => 'no-ckeditor')),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
//        'view' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
        'html' => new sfValidatorString(array('required' => false)),
    ));
    
//    $moduleViews = Layout::getViewForModule($this->moduleName);
    
//    if ($moduleViews !== false)
//    {
//      $this->setWidget('view', new sfWidgetFormChoice(array('choices' => $moduleViews)));
//      $this->setValidator('view', new sfValidatorChoice(array('choices' => array_keys($moduleViews))));
//    }

    if ($this->moduleName == 'article')
      unset($this['html']);
    
    if ($this->isNew())
    {
      $this->setWidget('module', new sfWidgetFormInputHidden(array('default' => $this->moduleId)));
      $this->setValidator('module', new sfValidatorDoctrineChoice(array('model' => 'Module', 'column' => 'id')));
      
      $this->getFieldsForNewForm();
    }
    else
      $this->getFieldsForEditForm();

    $this->widgetSchema->setNameFormat('layout[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
//    die('asdasd');
  }

  protected function getFieldsForNewForm()
  {
    $params = Doctrine::getTable('Param')->getParamsForModule($this->moduleName);

    foreach ($params as $param)
    {
      $this->setWidgetValidatorAndLabelForParam($param);
      $this->setDefault('param_' . $param->getUniqueName(), $param->getDefault());
    }
  }

  protected function getFieldsForEditForm()
  {
    $params = Doctrine::getTable('Param')->getParamsByLayoutIdAndModuleName($this->getObject()->getId(), $this->moduleName);

    foreach ($params as $param)
    {
      $this->setWidgetValidatorAndLabelForParam($param);
      $layoutParams = $param->getLayoutParams();
      $value = ($layoutParams->count()) ? $layoutParams->getFirst()->getValue() : $param->getDefault();
      $this->setDefault('param_' . $param->getUniqueName(), $value);
    }
  }

  /**
   * pobranie kodu validatora i widgetu dla konkretnego parametru oraz wywołanie i ustawienie konkretnego
   * validatora i widgetu dla danego pola
   * @param Param $param 
   */
  public function setWidgetValidatorAndLabelForParam(Param $param)
  {
    $widget = $param->getWidget();
    $validator = $param->getValidator();
    $uniqueName = $param->getUniqueName();
    $name = 'param_' . $uniqueName;

    $evalString = '$widget = ' . $widget . '; $validator = ' . $validator . ';';
    eval($evalString);

    $this->setWidget($name, $widget);
    $this->setValidator($name, $validator);
    $this->widgetSchema->setLabel($name, sfInflector::humanize($uniqueName));
  }
  
  public function setModuleName()
  {
    if ($this->isNew())
    {
      $filters = $this->getUser()->getAttribute('layout.filters', array(), 'admin_module');
//    $filters['module_id'];
      $this->moduleName = 'article'; 
      $this->moduleId = 3;
//    Doctrine::getTable('Module')->find($this->moduleId)->getName();
    }
    else
    {
      $this->moduleName = $this->getObject()->getModule()->getName();
//      $this->moduleName = 'article'; 
//      $this->moduleId = 3;
      $this->moduleId = $this->getObject()->getModuleId();
    }
  }

  public function save($con = null)
  {
    if ($this->isNew())
    {
      $this->values['module_id'] = $this->values['module'];
      unset($this->values['module']);
    }
    
    $object = parent::save($con);
    $objectId = $object->getId();

    $paramsValues = array();
    
    //dodaj do tablicy $paramsValues wszystkie wartości parametrów dodawanych dynamicznie (czyli tych z przedrostkiem "param")
    foreach ($this->values as $name => $value)
    {
      if (!artString::startsWith('param_', $name))
        continue;

      $paramsValues[substr($name, strlen('param_'))] = $value;
    }
    
    if (!empty($paramsValues))
    {
      //pobierz idki paramsów dla konkretnych nazw parametrów
      $paramsIds = Param::getParamsIdsByParamsNames(array_keys($paramsValues));
      
      //jeżeli nie jest nowy formularz, to pobierz layoutParams dla konkretnych parametrów i layout_id
      if (!$this->isNew())
        $layoutParams = LayoutParam::getLayoutParamsByParamsNamesAndLayoutId(array_keys($paramsValues), $objectId);

      //dla całej tablicy pobranych przez formularz parametrów
      foreach ($paramsValues as $name => $value)
      {
        //jeżeli formularz jest nowy, lub nie istnieje layoutParam w bazie dla konkretnego parametru (czyli parametr został dodany do bazy,
        //ale jeszcze nie został dodany wpis w layoutParam), to stwórz nowy layoutParam
        if ($this->isNew() || !isset($layoutParams[$name]))
        {
          $layoutParamObject = new LayoutParam();
          $layoutParamObject->setLayoutId($objectId);
          $layoutParamObject->setParamId($paramsIds[$name]);
        }
        
        //jeżeli wpis w bazie już istnieje, to go pobierz
        else
          $layoutParamObject = $layoutParams[$name];

        //jezeli wartość pobrana przez formularz jest różna od tej pobranej z bazy, to zapisz zmianę
        if ($layoutParamObject->getValue() != $value)
        {
          $layoutParamObject->setValue($value);
          $layoutParamObject->save();
        }
        
      }
    }

    artTask::clearCache();
    
    return $object;
  }

}