<?php

/**
 * Formularz backendowy zmiany ArtConfiguration
 * @subpackage artCmsPlugin

 */
class PluginFlatyArtConfigurationForm extends BaseArtConfigurationForm {

  public function configure() {
    $this->useFields(array('id', 'name', 'editable', 'order'));
    
    $this->setWidget('name', new sfWidgetFormInputText());

    foreach ($this->getPreferredCulture() as $culture) {
      $this->embedForm($culture, new FlatyArtConfigurationTranslationForm($this->getObject()->Translation[$culture]));
    }
    $this->widgetSchema->setLabels($this->getCultureLabels());

    foreach ($this->getFormFieldSchema() as $name => $field) {
        $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
}
