<?php

/**
 * Formularz backendowy zmiany ArtConfigurationTranslation
 * @subpackage artCmsPlugin

 */
class PluginFlatyArtConfigurationTranslationForm extends BaseArtConfigurationTranslationForm {

  public function configure() {
    $this->useFields(array('id', 'value', 'label', 'hint'));
    
    $this->setWidget('value', new sfWidgetFormInputText());
    $this->setWidget('hint', new sfWidgetFormInputText());
    $this->setValidator('value', new sfValidatorString(array('required' => false)));

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
}
