<?php

/**
 * Description of BaseFormLevelRenderer
 *
 */
abstract class BaseFormLevelRenderer implements InterfaceLevelRenderer
{

  /** @var BaseForm * */
  protected $form;
  protected $max = 1;
  protected $attributes;
  protected $levels;
  protected $renderedForm;
  protected $renderedGlobalErrors;
  protected $renderedErrors;
  protected $renderedFields;
  protected $spanAfterLabelClass;
  public $divLevels = false;

  /**
   * eg return new FormLevelRenderer()
   * @param form $form object: $this
   * @param array $attributes 
   */
  public function __construct($form, $levels = array(), $attributes = array(), $spanAfterLabelClass = false)
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers(array('I18N'));
//    if( !($form instanceof BaseForm) )
//      throw new Exception('Something went wrong! Contact to the admin', 500);

    $this->form = $form;
    $this->levels = $levels;
    $this->attributes = $attributes;
    $this->spanAfterLabelClass = $spanAfterLabelClass;

    $this->renderedErrors = self::_EMPTY_STRING;
    $this->renderedGlobalErrors = self::_EMPTY_STRING;

    $this->setMaxLevelCount();
  }

  public function setMaxLevelCount()
  {
    foreach ($this->levels as $level)
      if (count($level) > $this->max)
        $this->max = count($level);
  }

  public function renderGlobalErrorsRow()
  {
    $renderedHiddenFieldsRow = self::renderTd($this->form->renderHiddenFields(), self::_EMPTY_STRING);
    $renderedGlobalErrors = self::_EMPTY_STRING;

    if ($this->form->hasGlobalErrors())
      $renderedGlobalErrors = $this->form->renderGlobalErrors();

    $renderedGlobalErrors = self::renderTd($renderedGlobalErrors, self::_GLOBAL_ERROR_RENDER_TD_CLASS, array('colspan' => $this->max - 1));

    $this->renderedGlobalErrors = $renderedHiddenFieldsRow . $renderedGlobalErrors;

    return self::renderTr($this->renderedGlobalErrors, self::_HIDDEN_FIELDS, array('style' => 'display: none'));
  }

  public function __toString()
  {
    try
    {
      return $this->render();
    }
    catch (Exception $e)
    {
      echo $e->getMessage();
    }
  }

  public function renderEmbedFormLabel($formWidget, $name)
  {
    $td = self::renderTd(__($formWidget->renderLabel()), self::_EMBED_FORM_LABEL . '-' . $name, array('colspan' => $this->max));
    return self::renderTr($td, self::_EMPTY_STRING);
  }

  abstract function render();

  public final static function renderTd($content, $widgetClass, $options = array())
  {
    return self::renderType('td', $content, $widgetClass, $options);
  }

  public final static function renderDiv($content, $widgetClass, $options = array())
  {
    return self::renderType('div', $content, $widgetClass, $options);
  }

  public final static function renderTr($content, $class, $options = array())
  {
    $options['class'] = isset($options['class']) ? $options['class'] . ' sf_admin_form_level ' : 'sf_admin_form_level ';
    return self::renderType('tr', $content, $class, $options);
  }

  public function renderLevelErrorContent($formWidget)
  {
    return $formWidget->renderError($this->attributes);
  }

  public function renderLevelFieldContent($formWidget, $name = '')
  {
    $help = $formWidget->renderHelp($this->attributes);
    $help = $help != '' ? '<div class="help">' . str_replace('<br />', '', $help) . '</div>' : '';
    $spanAfterLabel = $this->spanAfterLabelClass ? '<span class="' . $this->spanAfterLabelClass . '"></span>' : '';

    try
    {
      $label = $this->form->getWidgetSchema()->getFormFormatter()->generateLabel($name);
    }
    catch (Exception $e)
    {
      $label = $formWidget->renderLabel($this->attributes);
    }

    $error = $this->renderLevelErrorContent($formWidget);
    $widget = $formWidget->render($this->attributes);
    
    $errorClass = $error == '' ? '' : sfConfig::get('widgetRenderSchemaErrorClass', 'div_widget_field_error');
    
    
    return str_replace(
            array('%error%', '%label%', '%spanAfterLabel%', '%widget%', '%help%', '%errorClass%'), 
            array($error, $label, $spanAfterLabel, $widget, $help, $errorClass), 
            sfConfig::get('widgetRenderSchema', '%error% %label% %spanAfterLabel% %widget% %help%')
        );
  }

  public final static function renderType($type, $content, $widgetClass, $options = array())
  {
    sfContext::getInstance()->getConfiguration()->loadHelpers('Tag');

    if (isset($options['class']))
      $options['class'] .= $widgetClass;
    else
      $options['class'] = $widgetClass;

    return content_tag($type, $content, $options);
  }

  public function isWidgetNotExistAndIsHidden($widget)
  {
    if (isset($this->form[$widget]))
      if (!$this->form[$widget]->isHidden())
        return false;

    return true;
  }

  public function getMax()
  {
    return $this->max;
  }

  public function setMax($max)
  {
    $this->max = $max;
  }

}