<?php

/**
 * Description of FormLevelRender
 *
 */
class FormLevelRenderer extends BaseFormLevelRenderer
{

  public function render()
  {
    $this->renderedForm .= $this->form->renderHiddenFields();
    $this->renderedForm .= $this->renderGlobalErrorsRow();
    $embededForms = $this->form->getEmbeddedForms();
    $ok = true;
    
    foreach( $this->levels as $key => $level )
    {
      if( isset($embededForms[$key]) )
      {
        unset($embededForms[$key]);
        $this->renderedForm .= $this->renderEmbedFormLevel($key, $level);
      }
      else
        $this->renderedForm .= $this->renderLevelFieldRow($level);
    }
    
//    $this->renderedForm .= $this->renderDefaultEmbededForm($embededForms);
    return $this->renderedForm;
  }

  public function setDivLevels($divLevels = false)
  {
    $this->divLevels = $divLevels;
  }
  
  public function renderLevelFieldRow($widgets)
  {
    $renderedFields = self::_EMPTY_STRING;
    
    if(empty($widgets))
      return $renderedFields;

    if ($this->divLevels)
      $renderedFields = '<td>';
    
    foreach( $widgets as $key => $widget )
    {
      $options = array(); //array('colspan' => $this->getColspan(count($widgets), $key));
      if($this->isWidgetNotExistAndIsHidden($widget))
        $content = '';
      else
        $content = $this->renderLevelFieldContent($this->form[$widget], $widget);
      
      if ($this->divLevels)
      {
        $class = self::_FIELD_RENDER_DIV_CLASS . $widget;
        $renderedFields .= self::renderDiv($content, $class, $options);
      }
      else
      {
        $class = self::_FIELD_RENDER_TD_CLASS . $widget;
        $renderedFields .= self::renderTd($content, $class, $options);
      }
    }

    if ($this->divLevels)
      $renderedFields .= '</td>';
      
    $trFields = self::renderTr($renderedFields, self::_FIELD_RENDER_TR_CLASS . $key);
    $this->renderedFields = $trFields;
    
    return $trFields;
  }
  
  public function renderEmbedFormLevel($key, $levels)
  {
    $embedFormLevel = $this->renderEmbedFormLabel($this->form[$key], $key);
    
    if(empty($levels) || !isset($levels[0]))
      return $this->form[$key]->render();
    
    foreach($levels as $widgets)
      $embedFormLevel .= $this->renderLevelEmbedForm($key, $widgets);
    return $embedFormLevel;
  }
  /**
   *
   * @param string $name name of embedded forms
   * @param type $widgets
   */
  public function renderLevelEmbedForm($name, $widgets)
  {
    $renderedEmbedFormFields = self::_EMPTY_STRING;
    
    if( empty($widgets) || !isset($widgets[0]))
      return $this->form[$name]->render();
//    
    foreach( $widgets as $key => $widget )
    {
      if( !isset($this->form[$name][$widget]))
        continue;
      if( $this->form[$name][$widget]->isHidden() )
        continue;

      $renderedEmbedFormFields .= self::renderTd($this->renderLevelFieldContent($this->form[$name][$widget]), self::_FIELD_RENDER_TD_CLASS . $name . "_" . $widget, array( 'colspan' => $this->getColspan(count($widgets), $key) ));
    }

    return self::renderTr($renderedEmbedFormFields, self::_FIELD_RENDER_TR_CLASS . "_" . $name);
  }

  public function getColspan($count, $actual)
  {
    if( $count == $actual + 1 )
      return $this->max - $actual;
    else
      return 0;
  }
  
  public function renderDefaultEmbededForm($embededForms)
  {
      $renderedEmbededForm = self::_EMPTY_STRING; 
    
    if(empty($embededForms))
      return $renderedEmbededForm;
    
    foreach($embededForms as $key => $ebedForm)
    {
      $renderedEmbededForm .= $this->renderEmbedFormLabel($this->form[$key], $key); 
      $renderedEmbededForm .= $this->form[$key]->render();
    }
    
    return $renderedEmbededForm;
  }

}