<?php

function include_module_action($module, $action) {

    $controller = sfContext::getInstance()->getController();

    $presentation = $controller->getPresentationFor($module, $action);

    return $presentation;
}

/**
 * Zwraca kod JS funckji w JS.
 *
 * @param $functions
 */
function echo_ajax_functions($functions) {

    foreach ($functions as $function) {
        if (!isset($function['f_params'])) {
            $function['f_params'] = '';
        }

        if (!isset($function['params'])) {
            $function['params'] = false;
        }

        ajax_function($function['f_name']
                , $function['f_params']
                , $function['url']
                , $function['params']
                , $function['ajax_options']);
    }
}

/**
 * Zwraca kod JS funkcji.
 *
 * @param $f_name
 * @param $f_params
 * @param $url
 * @param $params
 * @param $ajax_options
 */
function ajax_function($f_name, $f_params, $url, $params, $ajax_options) {

    if (!isset($ajax_options['accepts'])) {
        $ajax_options['type'] = 'POST';
    };

    if (!isset($ajax_options['dataType'])) {
        $ajax_options['dataType'] = 'html';
    };

    if (!isset($ajax_options['beforeSend'])) {
        $ajax_options['beforeSend'] = 'function(){}';
    };

    if (!isset($ajax_options['success'])) {
        $ajax_options['success'] = 'function(){}';
    };

    if (!isset($ajax_options['async'])) {
        $ajax_options['async'] = true;
    };

    echo ' function ' . $f_name . '(' . $f_params . '){
    ' . (($params) ? 'var params =' . $params . ';' : '') . '
    jQuery.ajax({
      statusCode: {
        404: function() {
          alert("Nie odnaleziono strony");
        },
        500: function() {
          alert("Wystąpił nieokreslony błąd ! Sprawdź połącznie z internetem. Jeżeli problem nie zostanie rozwiązany skontaktuj się z administratorem strony.");
        }
      },
      type:\'' . $ajax_options['type'] . '\',
      dataType:\'' . $ajax_options['dataType'] . '\',
      beforeSend:' . $ajax_options['beforeSend'] . ',
      success:' . $ajax_options['success'] . ',
      url:\'' . url_for($url) . '\'' . (($params) ? '+params' : '') . '
    })
  } ';
}

function ajax_success_function($f_name, $f_params) {

    echo '
  function fmArticleAddSuccess(data) {
    stopIndicator();
    if (data == \'Success\') {
      fmSuccess();
    } else if (data == \'NoPermission\') {
      fmNoPermission();
    } else {
      fmOpenPopup(\'fm-popup\', data, \' Tytuł \');
      fmInitCKE();
    }
  }';
}

/*
 * Matoda tworząca i wstawijąca do widoku buttony;.
 * $name - nazwa wyświetlana w inpucie;
 * $internal_uri - link do którego ma prowadzić.
 * $options tablica z opcjami html.
 */

function btn_to($name, $internal_uri, $options = array()) {
    $html_options = _parse_attributes($options);
    $html_options['value'] = $name;

    if (isset($html_options['class'])) {
        $html_options['class'] .= ' btn';
    } else {
        $html_options['class'] = 'btn';
    }

    if ((isset($html_options['submit']) && $html_options['submit']) || (isset($html_options['no_link']) && $html_options['no_link'])) {
        if (isset($html_options['popup'])) {
            throw new sfConfigurationException('You can\'t use "popup" and "post" together.');
        }

        if (isset($html_options['no_link']) && $html_options['no_link']) {

            if (!isset($html_options['type'])) {
                $html_options['type'] = 'button';
            }
            
        } else {
            $html_options['type'] = 'submit';
        }

//    if (isset($html_options['onclick'])) {
//      $html_options['onclick'] .= "$(this).attr('disabled', true);";
//    } else {
//      $html_options['onclick'] = "$(this).attr('disabled', true);";
//    }

        unset($html_options['post']);
        unset($html_options['submit']);
        unset($html_options['no_link']);
        unset($html_options['url_for']);

        $html_options = _convert_options_to_javascript($html_options);

        if (isset($html_options['artbox']) && $html_options['artbox'] == true || sfConfig::get('app_buttons_artbox', false)) {
            return content_tag('div', artBox::beginBox('horizontal') . tag('input', $html_options) . artBox::endBox('horizontal'), array('class' => 'box_button'));
        } else {
            return tag('input', $html_options);
        }
    }

    if (isset($html_options['url_for']) && $html_options['url_for'] == false) {
        $url = $internal_uri;
    } else {
        $url = url_for($internal_uri);
    }

    if (isset($html_options['query_string'])) {
        $url = $url . '?' . $html_options['query_string'];
        unset($html_options['query_string']);
    }

    if (isset($html_options['anchor'])) {
        $url = $url . '#' . $html_options['anchor'];
        unset($html_options['anchor']);
    }

    $url = "'" . $url . "'";
    $html_options['type'] = 'button';

    if (isset($html_options['popup'])) {
        $html_options = _convert_options_to_javascript($html_options, $url);
        unset($html_options['popup']);
        unset($html_options['submit']);
        unset($html_options['no_link']);
        unset($html_options['url_for']);
    } else {
        unset($html_options['submit']);
        unset($html_options['no_link']);
        unset($html_options['url_for']);
        $html_options['onclick'] = "document.location.href=" . $url . ";";
        $html_options = _convert_options_to_javascript($html_options);
    }

    if (isset($html_options['artbox']) && $html_options['artbox'] == true || sfConfig::get('app_buttons_artbox', false)) {
        return content_tag('div', artBox::beginBox('horizontal') . tag('input', $html_options) . artBox::endBox('horizontal'), array('class' => 'box_button'));
    } else {
        return tag('input', $html_options);
    }
}

function stripTags($text) {
    return strip_tags(html_entity_decode($text));
}

function addDotes($text) {
    return artStringConverter::addDotes($text, 60);
}

function addDotesWithStripTags($text) {
    return addDotes(stripTags($text));
}

function getValueInPLN($value) {
    return number_format($value, 2, '.', '') . 'zł';
}

function getValueInSqm($value) {
    return number_format($value, 2, '.', '') . __('m2');
}

function getLanguage($value) {
    return __(sfCultureInfo::getInstance()->getLanguage($value));
}

function getLogFlag($flag) {
    if ($flag == 0)
        $value = 'inserted';
    else if ($flag == 1)
        $value = 'updated';
    else if ($flag == 2)
        $value = 'deleted';
    else
        $value = 'translation inserted';

    echo __('Record ' . $value);
}

function categoryImage($categoryObject) {
    artEscaper::escape($categoryObject);

    if ($categoryObject->hasTitleImage() && file_exists(Category::getTitleImageAbsolutePath() . $categoryObject->getTitleImage()))
        echo image_tag(Category::getTitleImagePath() . $categoryObject->getTitleImage(), array('width' => 50, 'height' => 50));
}

function getLink($value) {
    if (isset($value) && $value != '') {
        try {
            return link_to($value, $value);
        } catch (Exception $e) {
            return $value;
        }
    } else
        return '';
}

function getLogicName($value) {
    return $value ? __('Yes') : __('No');
}

function jq_link_to_remote_with_onclick($name, $options = array(), $html_options = array()) {
    return jq_link_to_function_with_onclick($name, jq_remote_function($options), $html_options);
}

function jq_link_to_function_with_onclick($name, $function, $html_options = array()) {
    $html_options = _parse_attributes($html_options);
    $html_options['href'] = isset($html_options['href']) ? $html_options['href'] : '#';

    if (!isset($html_options['onclick']))
        $html_options['onclick'] = '';

    if (isset($html_options['confirm'])) {
        $confirm = escape_javascript(__($html_options['confirm']));
        $html_options['onclick'] = $html_options['onclick'] . " if(confirm('$confirm')){ $function;}; return false;";
        unset($html_options['confirm']);
    } else
        $html_options['onclick'] = $html_options['onclick'] . $function . '; return false;';

    return content_tag('a', $name, $html_options);
}

function isDev() {
    return sfConfig::get('sf_environment') == 'dev';
}

/**
 * Prints <script> tags for all javascripts configured in view.yml or added to the response object.
 *
 * @see get_javascripts()
 */
function include_javascripts_with_dynamic() {
    echo get_javascripts_with_dynamic();
}

/**
 * Returns <script> tags for all javascripts configured in view.yml or added to the response object.
 *
 * You can use this helper to decide the location of javascripts in pages.
 * By default, if you don't call this helper, symfony will automatically include javascripts before </head>.
 * Calling this helper disables this behavior.
 *
 * @return string <script> tags
 */
function get_javascripts_with_dynamic() {
    $response = sfContext::getInstance()->getResponse();
    sfConfig::set('symfony.asset.javascripts_included', true);
    $html = '';

    foreach ($response->getJavascripts() as $file => $options) {
        if (substr($file, 0, 1) == '@')
            $html .= javascript_include_tag_with_dynamic($file, $options);
        else
            $html .= javascript_include_tag($file, $options);
    }

    return $html;
}

/**
 * Returns a <script> include tag per source given as argument.
 *
 * <b>Examples:</b>
 * <code>
 *  echo javascript_include_tag('xmlhr');
 *    => <script language="JavaScript" type="text/javascript" src="/js/xmlhr.js"></script>
 *  echo javascript_include_tag('common.javascript', '/elsewhere/cools');
 *    => <script language="JavaScript" type="text/javascript" src="/js/common.javascript"></script>
 *       <script language="JavaScript" type="text/javascript" src="/elsewhere/cools.js"></script>
 * </code>
 *
 * @param string asset names
 * @param array additional HTML compliant <link> tag parameters
 *
 * @return string XHTML compliant <script> tag(s)
 * @see    javascript_path
 */
function javascript_include_tag_with_dynamic() {
    $sources = func_get_args();
    $sourceOptions = (func_num_args() > 1 && is_array($sources[func_num_args() - 1])) ? array_pop($sources) : array();
    $html = '';

    foreach ($sources as $source) {
        $absolute = false;
        $condition = null;

        if (isset($sourceOptions['absolute'])) {
            unset($sourceOptions['absolute']);
            $absolute = true;
        }

        if (isset($sourceOptions['condition'])) {
            $condition = $sourceOptions['condition'];
            unset($sourceOptions['condition']);
        }

        if (!isset($sourceOptions['raw_name']))
            $source = javascript_path_with_dynamic($source, $absolute);
        else
            unset($sourceOptions['raw_name']);

        $options = array_merge(array('type' => 'text/javascript', 'src' => $source), $sourceOptions);
        $tag = content_tag('script', '', $options);

        if (null !== $condition)
            $tag = comment_as_conditional($condition, $tag);

        $html .= $tag . "\n";
    }

    return $html;
}

/**
 * Returns the path to a JavaScript asset.
 *
 * <b>Example:</b>
 * <code>
 *  echo javascript_path('myscript');
 *    => /js/myscript.js
 * </code>
 *
 * <b>Note:</b> The asset name can be supplied as a...
 * - full path, like "/my_js/myscript.css"
 * - file name, like "myscript.js", that gets expanded to "/js/myscript.js"
 * - file name without extension, like "myscript", that gets expanded to "/js/myscript.js"
 *
 * @param string $source   asset name
 * @param bool   $absolute return absolute path ?
 *
 * @return string file path to the JavaScript file
 * @see    javascript_include_tag
 */
function javascript_path_with_dynamic($source, $absolute = false) {
    return _compute_public_path_with_dynamic(url_for($source . '?sf_format=js'), '', '', $absolute = true);
}

function _compute_public_path_with_dynamic($source, $dir, $ext, $absolute = false) {
    if (strpos($source, '://'))
        return $source;

    $request = sfContext::getInstance()->getRequest();
    $sf_relative_url_root = $request->getRelativeUrlRoot();

    if (0 !== strpos($source, '/'))
        $source = $sf_relative_url_root . '/' . $dir . '/' . $source;

    $query_string = '';

    if (false !== $pos = strpos($source, '?')) {
        $query_string = substr($source, $pos);
        $source = substr($source, 0, $pos);
    }

    if ($sf_relative_url_root && 0 !== strpos($source, $sf_relative_url_root))
        $source = $sf_relative_url_root . $source;

    if ($absolute)
        $source = 'http' . ($request->isSecure() ? 's' : '') . '://' . $request->getHost() . $source;

    return $source . $query_string;
}

function distance_of_time_short_words($from_time, $to_time = null, $include_seconds = false) {
    $to_time = $to_time ? strtotime($to_time) : time();

    $distance_in_minutes = floor(abs($to_time - $from_time) / 60);
    $distance_in_seconds = floor(abs($to_time - $from_time));
    $string = '';
    $parameters = array();

    if ($to_time - $from_time < 0)
        $string = '<1m';
    else {
        if ($distance_in_minutes <= 1) {
            if (!$include_seconds)
                $string = $distance_in_minutes <= 0 ? '<1m' : '1m';
            else {
                if ($distance_in_seconds <= 5)
                    $string = 'less than 5 seconds';
                else if ($distance_in_seconds >= 6 && $distance_in_seconds <= 10)
                    $string = 'less than 10 seconds';
                else if ($distance_in_seconds >= 11 && $distance_in_seconds <= 20)
                    $string = 'less than 20 seconds';
                else if ($distance_in_seconds >= 21 && $distance_in_seconds <= 40)
                    $string = 'half a minute';
                else if ($distance_in_seconds >= 41 && $distance_in_seconds <= 59)
                    $string = 'less than a minute';
                else
                    $string = '1 minute';
            }
        }
        else if ($distance_in_minutes >= 2 && $distance_in_minutes <= 44) {
            $string = '%minutes%m';
            $parameters['%minutes%'] = $distance_in_minutes;
        } else if ($distance_in_minutes >= 45 && $distance_in_minutes <= 89)
            $string = '1h';
        else if ($distance_in_minutes >= 90 && $distance_in_minutes <= 1439) {
            $string = '%hours%h';
            $parameters['%hours%'] = round($distance_in_minutes / 60);
        } else if ($distance_in_minutes >= 1440 && $distance_in_minutes <= 2879)
            $string = '1d';
        else if ($distance_in_minutes >= 2880 && $distance_in_minutes <= 43199) {
            $string = '%days%d';
            $parameters['%days%'] = round($distance_in_minutes / 1440);
        } else if ($distance_in_minutes >= 86400 && $distance_in_minutes <= 525959) {
            $string = '%months% months';
            $parameters['%months%'] = round($distance_in_minutes / 43200);
        } else if ($distance_in_minutes >= 525960 && $distance_in_minutes <= 1051919)
            $string = 'about 1 year';
        else {
            $string = 'over %years% years';
            $parameters['%years%'] = floor($distance_in_minutes / 525960);
        }
    }
    return __($string, $parameters);
}

function distance_of_time_in_long_words($from_time, $to_time = null, $include_seconds = false) {
    $to_time = $to_time ? strtotime($to_time) : time();

    $distance_in_minutes = round(floor($to_time - $from_time) / 60);
    $distance_in_seconds = floor($to_time - $from_time);

    $string = '';
    $parameters = array();

    if ($to_time - $from_time < 0)
        $string = 'less than a minute';
    else {
        if ($distance_in_minutes <= 1) {
            if (!$include_seconds)
                $string = $distance_in_minutes == 0 ? 'less than a minute' : '1 minute';
            else {
                if ($distance_in_seconds <= 5)
                    $string = 'less than 5 seconds';
                else if ($distance_in_seconds >= 6 && $distance_in_seconds <= 10)
                    $string = 'less than 10 seconds';
                else if ($distance_in_seconds >= 11 && $distance_in_seconds <= 20)
                    $string = 'less than 20 seconds';
                else if ($distance_in_seconds >= 21 && $distance_in_seconds <= 40)
                    $string = 'half a minute';
                else if ($distance_in_seconds >= 41 && $distance_in_seconds <= 59)
                    $string = 'less than a minute';
                else
                    $string = '1 minute';
            }
        }
        else if ($distance_in_minutes >= 2 && $distance_in_minutes <= 4) {
            $string = '%minutes% minutes2-4';
            $parameters['%minutes%'] = $distance_in_minutes;
        } else if ($distance_in_minutes >= 5 && $distance_in_minutes <= 59) {
            $string = '%minutes% minutes';
            if ($distance_in_minutes >= 20) {
                if ($distance_in_minutes % 10 >= 2 && $distance_in_minutes % 10 <= 4)
                    $string = '%minutes% minutes2-4';
            }
            $parameters['%minutes%'] = $distance_in_minutes;
        }
        else if ($distance_in_minutes >= 60 && $distance_in_minutes <= 119) {
            $string = '1 hour';
        } else if ($distance_in_minutes >= 120 && $distance_in_minutes <= 1439) {
            $string = '%hours% hours';
            $hours = round($distance_in_minutes / 60);
            if ($hours >= 2 && $hours <= 4)
                $string = '%hours% hours2-4';
            if ($hours >= 20) {
                if ($hours % 10 >= 2 && $hours % 10 <= 4)
                    $string = '%hours% hours2-4';
            }
            $parameters['%hours%'] = $hours;
        }
        else if ($distance_in_minutes >= 1440 && $distance_in_minutes <= 2879)
            $string = '1 day';
        else if ($distance_in_minutes >= 2880 && $distance_in_minutes <= 43199) {
            $string = '%days% days';
            $parameters['%days%'] = round($distance_in_minutes / 1440);
        } else if ($distance_in_minutes >= 43200 && $distance_in_minutes <= 86399)
            $string = '1 month';
        else if ($distance_in_minutes >= 86400 && $distance_in_minutes <= 525959) {
            $string = '%months% months';
            $months = round($distance_in_minutes / 43200);
            if ($months >= 2 && $months <= 4)
                $string = '%months% months2-4';
            if ($months >= 20) {
                if ($months % 10 >= 2 && $months % 10 <= 4)
                    $string = '%months% months2-4';
            }
            $parameters['%months%'] = $months;
        }
        else if ($distance_in_minutes >= 525960 && $distance_in_minutes <= 1051919)
            $string = '1 year';
        else if ($distance_in_minutes >= 1051920) {
            $string = '%years% years';
            $years = floor($distance_in_minutes / 525960);

            if ($years >= 2 && $years <= 4)
                $string = '%years% years2-4';
            if ($years >= 20) {
                if ($years % 10 >= 2 && $years % 10 <= 4)
                    $string = '%years% years2-4';
            }
            $parameters['%years%'] = $years;
        }
    }

    return __($string, $parameters);
}

function includeFrontendArticleActionLink($name, $url, $class = '', $linkOptions = array(), $ajaxOptions = array()) {
    return getFrontendArticleActionLink($name, $url, $class, $linkOptions, $ajaxOptions);
}

function getFrontendArticleActionLink($name, $url, $class = '', $linkOptions = array(), $ajaxOptions = array()) {
    return get_partial('article/link_to_frontend_action_button', array('name' => $name, 'url' => $url, 'class' => $class, 'options' => $linkOptions, 'ajaxOptions' => $ajaxOptions));
}

function decodeFrontendCategoryHash($hash) {
    return substr(substr($hash, 15), 0, 3);
}

/**
 * return an url for a given symfony application and an internal url
 *
 * @author Olivier Mansour
 *
 * @param string $appname
 * @param string $url
 * @param boolean $absolute
 * @param string $env
 * @param boolean $debug
 * @return string
 */
function cross_app_url_for($appname, $url, $absolute = false, $env = null, $debug = false) {
    $initial_app = sfContext::getInstance()->getConfiguration()->getApplication();
    $initial_web_controler = basename(sfContext::getInstance()->getRequest()->getScriptName());
    $initial_config = sfConfig::getAll();
    // get the environment
    if (is_null($env)) {
        $env = sfContext::getInstance()->getConfiguration()->getEnvironment();
    }
    // context creation
    if (!sfContext::hasInstance($appname)) {
        $context = sfContext::createInstance(ProjectConfiguration::getApplicationConfiguration($appname, $env, $debug), $appname);
    } else {
        $context = sfContext::getInstance($appname);
    }
    $web_url = $context->getController()->genUrl($url, $absolute);
    sfContext::switchTo($initial_app);
    sfConfig::add($initial_config);
    unset($context);
    //remove initial web controler
    // genUrl use $this->context->getRequest()->getScriptName();, its a call to $_SERVER
    // so starting the shameless part !
    $script_name = $appname;
    if (($env != 'prod') and $env) {
        $script_name.='_' . $env;
    } elseif ($script_name == "frontend") {
        $script_name = "index";
    }
    $script_name.='.php';
    // check if this file exist
    if (!file_exists(sfConfig::get('sf_web_dir') . DIRECTORY_SEPARATOR . $script_name))
        throw new sfException('can t find ' . $script_name . ' in the web directory');
    $web_url = str_replace($initial_web_controler, $script_name, $web_url);
    return $web_url;
}
