<?php
/**
 * Description of FixturesHelper
 *
 
 */

class FixturesHelper extends FixturesHelperData
{
    /**
     * Generuje lorem ipsum.
     *
     * @param int $minChars
     * @param bool $maxChars
     * @param bool $fromBeginning
     * @return string
     */
    public static function generateLoremIpsum($minChars = 50, $maxChars = false, $fromBeginning = true)
    {
        $chars = rand($minChars, !$maxChars ? strlen(self::$loremIpsum) : $maxChars);

        if ($chars > strlen(self::$loremIpsum)) {
            $stringRepeats = (int)($chars / strlen(self::$loremIpsum));
            $string = str_repeat(self::$loremIpsum, $stringRepeats);
            $chars = $chars % strlen(self::$loremIpsum);
        } else
            $string = '';

        if ($fromBeginning)
            return $chars == 0 ? self::$loremIpsum : substr(self::$loremIpsum, 0, $chars) . $string;
        else
            return $chars == 0 ? self::$loremIpsum : substr(self::$loremIpsum, rand(0, strlen(self::$loremIpsum) - $chars), $chars) . $string;
    }

    /**
     * @param $array
     * @return mixed
     */
    public static function randAssocArrayKey($array)
    {
//    //wyciągnięcie samych kluczy
//    $array = array_keys($array);
//    //przemieszanie tablicy
//    shuffle($array);
//    //pobranie pierwszego elementu
//    return $array[0];
        return array_rand($array);
    }

    /**
     * @param $array
     * @param $count
     * @return array
     */
    public static function randArrayFromArray($array, $count)
    {
        shuffle($array);

        return array_slice($array, 0, $count);
    }

    /**
     * @param $province
     * @param $district
     */
    public static function randProvinceAndDistrict(&$province, &$district)
    {
        $province = array_rand(self::$provinces);
        $district = self::$provinces[$province][array_rand(self::$provinces[$province])];
    }

    /**
     * @param $min
     * @param $max
     * @param array $bannedValues
     * @return int
     */
    public static function rand($min, $max, $bannedValues = array())
    {
        if (!is_array($bannedValues))
            $bannedValues = array($bannedValues);

        do
            $value = rand($min, $max);
        while (in_array($value, $bannedValues));

        return $value;
    }

    /**
     * @param $min
     * @param $max
     * @param $numberOfValues
     * @return array
     */
    public static function randValues($min, $max, $numberOfValues)
    {
        $possibleValues = range($min, $max);

        $numberOfValues = min($max, $numberOfValues);

        return self::randArrayFromArray($possibleValues, $numberOfValues);
    }

    /**
     * @return string
     */
    public static function randNip()
    {
        return rand(100, 999) . '-' . rand(100, 999) . '-' . rand(10, 99) . '-' . rand(10, 99);
    }
}
