<?php
/**
 * Description of BaseMenuGenerator
 *
 
 */

class BaseOldMenuGenerator
{

    public function getUser()
    {
        return sfContext::getInstance()->getUser();
    }

    public function getUserLang()
    {
        return $this->getUser()->getCulture();
    }

    /**
     * funkcja pobierająca domyślnie ustawienia
     * @return array
     */
    public final function getDefaultSettings()
    {
        return array_merge(array(
            'links_with_icon' => false,
            'class_active' => 'active-menu',
            'class_active_in_submenu' => 'active-in-submenu',
            'class_inactive' => null,
            'class_all_links' => 'menu-a',
            'class_menu' => 'menu',
            'cache' => true,
            'create_partial' => true,
            'menu_partial_name' => 'menu',
            'permissions' => array(),
            'with_spacer' => false,
            'submenu_generator_class' => 'OldSubmenuGenerator',
            'spacer' => array(
                'tags' => array(
                    'span' => array(
                        'class' => 'menu-spacer'
                    )
                ),
            ),
            'around_menu' => array(
                'tags' => array(
                    'div' => array(
                        'class' => 'menu'
                    )
                )
            ),
            'outside_link' => array(
                'tags' => array(
                    'span' => array(
                        'class' => 'menu-link'
                    )
                )
            ),
            'inside_link' => array()
        ), $this->extendDefaultSettings());
    }

    /**
     * funkcja do rozszerzania podstawowych ustawień w klasach dziedziczących
     * @return tablica
     */
    public function extendDefaultSettings()
    {
        return array();
    }

    /**
     * funkcja pobiera domyślnie opcje
     * @return array
     */
    public final function getDefaultOptions()
    {
        return array_merge(array(
            'settings' => array(),
            'options' => array(),
            'lang_options' => array(),
            'display_name' => true,
            'url_is_hash' => false,
            'has_a' => true,
            'can_be_active_link' => true,
            'only_dev' => false,
            'module' => null,
            'actions' => array(),
            'except_actions' => array(),
            'request_params' => array(),
            'except_request_params' => array(),
            'session_params' => array(),
            'count_model' => '',
            'count_method' => '',
            'count_prefix' => ' (',
            'count_suffix' => ') ',
        ), $this->extendDefaultOptions());
    }

    /**
     * funkcja do rozszerzania podstawowych opcji w klasach dziedziczących
     * @return array
     */
    public function extendDefaultOptions()
    {
        return array();
    }

    public function getHashReplacer()
    {
        return "http://to-jest-po-to-zeby-linkto-nie-robilo-problemow.pl";
    }

    /**
     * funkcja sprawdza czy istnieje odpowiedni folder na partiale, jeżeli nie, to go tworzy
     * @return string folder w cache'u na partiale menu
     */
    public function getPartialCacheDir()
    {
        $appModulesCacheDir = sfConfig::get('sf_module_cache_dir');
        $moduleCacheDir = $appModulesCacheDir . '/autoMenu';
        $moduleTemplateCacheDir = $moduleCacheDir . '/templates';

        if (!is_dir($moduleTemplateCacheDir))
            mkdir($moduleTemplateCacheDir, 0777, true);

        return $moduleTemplateCacheDir;
    }

    public function getSettingsValuesNamesForStringPHPArrays()
    {
        return array('class_active', 'class_inactive', 'class_all_links', 'links_with_icon');
    }

    public function getOptionsValuesNamesForStringPHPArrays()
    {
        return array('options', 'can_be_active_link', 'module', 'actions', 'except_actions', 'request_params', 'except_request_params', 'session_params', 'filter_from_link', 'url', 'count_model', 'count_method');
    }

    /**
     * funkcja ustawia tablice zmiennych z parametrów przekazanych w partialu
     * @param array $vars
     */
    public function setArraysForPartial($vars)
    {
        $this->url = $vars['url'];
        $this->settings = $vars['settings'];
        $this->options = $vars['options'];
        $this->linkYamlName = $vars['linkYamlName'];
        $this->menuName = $vars['menuName'];
    }

    /**
     * funkcja tworzy stringa z tablicą ustawień przekazywanych do partiala
     * @return string
     */
    public function createStringPHPArrays()
    {
        return 'array(' . $this->extendCreateStringPhpArrays() . '
      \'linkYamlName\' =] \'' . $this->linkYamlName . '\',
      \'menuName\' =] \'' . $this->menuName . '\',
      \'url\' =] \'' . $this->url . '\',
      \'settings\' =] ' . MenuHelper::createStringPHPArray($this->settings, $this->getSettingsValuesNamesForStringPHPArrays()) . ',
      \'options\' =] ' . MenuHelper::createStringPHPArray($this->options, $this->getOptionsValuesNamesForStringPHPArrays()) . '
    )';
    }

    /**
     * funkcja do nadpisania w klasach nadrzędnych, rozszerzająca tablicę z funkcji createStringPHPArrays
     * @return type
     */
    public function extendCreateStringPhpArrays()
    {
        return '';
    }

    /**
     * funkcja zwraca nazwę partiala
     * @return string nazwa partiala
     */
    public function getMenuPartialName()
    {
        $permission = $this->getUser()->isAuthenticated() ? 'signinUser' : 'guest';

        if (!empty($this->globalSettings['permissions'])) {
            foreach ($this->globalSettings['permissions'] as $i => $value)
                if ($this->getUser()->hasPermission($value)) {
                    $permission = $value;
                    break;
                }
        }

        return $this->globalSettings['menu_partial_name'] . ucfirst($permission) . ucfirst($this->getUserLang());
    }

    /**
     * funkcja tworzy partial
     * @param string $partialName nazwa partiala
     * @param string $fullMenu html z kodem menu
     * @param array $menuPartialVars tablica zmiennych do partiala
     * @return string zawartość partiala
     */
    public function createPartial($partialName, $fullMenu, $menuPartialVars)
    {
        $fullMenu = str_replace(array('[?php', '?]', '=]', '-]'), array('<?php', '?>', '=>', '->'), $fullMenu);

        $filename = $this->getPartialCacheDir() . '/_' . $partialName . '.php';
        $file = fopen($filename, 'w+');
        fwrite($file, $fullMenu);
        fclose($file);
        chmod($filename, 0777);

        return $this->getPartial($partialName, $menuPartialVars);
    }

    /**
     * funkcja zwraca partial z menu
     * @param string $partialName nazwa partiala
     * @param array $menuPartialVars tablica zmiennych do partiala
     * @return string zawartość partiala
     */
    public function getPartial($partialName, $menuPartialVars)
    {
        $menuPartialVars = array_merge(array('menuGenerator' => $this), $menuPartialVars);

        return get_partial('menu/' . $partialName, $menuPartialVars, array('sf_cache_key' => $this->getUserLang() . rand(0, 1000000000)));
    }

}