<?php
/**
 * Description of MenuHelper
 *
 
 */
class MenuHelper
{

    public static $activeClass = '';

    public static function getTag($settingsArray)
    {
        $tag = MenuHelper::createSettingsBeginTag($settingsArray);
        $tag .= MenuHelper::createBeginArtBox($settingsArray);
        $tag .= MenuHelper::createInsideArtBoxTags($settingsArray);

        $tag .= isset($settingsArray['content']) ? $settingsArray['content'] : '';

        $tag .= MenuHelper::createInsideArtBoxEndTags($settingsArray);
        $tag .= MenuHelper::createEndArtBox($settingsArray);
        $tag .= MenuHelper::createSettingsEndTag($settingsArray);

        return $tag;
    }

    public static function createSettingsTag($settingsArray)
    {
        $content = isset($settingsArray['content']) ? $settingsArray['content'] : '';
        return self::createSettingsBeginTag($settingsArray) . $content . self::createSettingsEndTag($settingsArray);
    }

    public static function createBeginTags($settingsArray, $name)
    {
        if (isset($settingsArray[$name])) {
            $tagsString = '';
            $isFirstTag = true;

            foreach ($settingsArray[$name] as $tag => $tagOptions) {
                if ($isFirstTag) {
                    if (isset($tagOptions['class']))
                        $tagOptions['class'] = $tagOptions['class'] . ' ' . self::$activeClass;
                    else
                        $tagOptions['class'] = self::$activeClass;

                    $isFirstTag = false;
                    self::$activeClass = '';
                }

                $tagsString .= tag($tag, $tagOptions, true);
            }

            return $tagsString . " \n";
        }

        return '';
    }

    public static function createEndTags($settingsArray, $name)
    {
        if (isset($settingsArray[$name])) {
            $tagsString = '';

            foreach ($settingsArray[$name] as $tag => $tagOptions)
                $tagsString = self::createEndTag($tag, false) . $tagsString;

            return $tagsString . " \n";
        }

        return '';
    }

    public static function createSettingsBeginTag($settingsArray)
    {
        return self::createBeginTags($settingsArray, 'tags');
    }

    public static function createSettingsEndTag($settingsArray)
    {
        return self::createEndTags($settingsArray, 'tags');
    }

    public static function createInsideArtBoxTags($settingsArray)
    {
        return self::createBeginTags($settingsArray, 'inside_artBox_tags');
    }

    public static function createInsideArtBoxEndTags($settingsArray)
    {
        return self::createEndTags($settingsArray, 'inside_artBox_tags');
    }

    public static function createBeginArtBox($settingsArray)
    {
        if (isset($settingsArray['artBox']))
            return artBox::beginBox($settingsArray["artBox"]);

        return '';
    }

    public static function createEndArtBox($settingsArray)
    {
        if (isset($settingsArray['artBox']))
            return artBox::endBox($settingsArray["artBox"]);

        return '';
    }

    public static function createEndTag($tag, $withNewLine = true)
    {
        if ($withNewLine)
            return " \n</" . $tag . '>';
        else
            return '</' . $tag . '>';
    }

    public static function createStringPHPArray($valuesArray, $valuesNamesArray, $allElements = false)
    {
        if ($allElements) {
            $valuesNamesArray = array();
            foreach ($valuesArray as $name => $value)
                $valuesNamesArray[] = $name;
        }

        $array = 'array(';

        foreach ($valuesNamesArray as $name) {
            if (!isset($valuesArray[$name]))
                $valuesArray[$name] = '';

            if (is_array($valuesArray[$name]))
                $array .= '\'' . $name . '\' =] ' . self::createStringPHPArray($valuesArray[$name], array(), true) . ', ';
            else
                $array .= '\'' . $name . '\' =] \'' . $valuesArray[$name] . '\', ';
        }

        $array .= ')';

        return $array;
    }

}
