<?php

/**
 * Description of MenuGenerator
 *
 
 */
class OldMenuGenerator extends BaseOldMenuGenerator
{

    /**
     *
     * @var array tablica generatora
     */
    public $generatorArray = array();
    /**
     *
     * @var array tablica z pozycjami menu
     */
    public $menu = array();
    /**
     *
     * @var array tablica ustawień globalnych dla menu. Poszczególne opcje możliwe do nadpisania w poszczególnych opcjach menu
     */
    public $globalSettings = array();
    /**
     *
     * @var array tablica ustawień aktualnej pozycji menu
     */
    public $settings = array();
    /**
     *
     * @var string w tej zmiennej będzie przechowywany kod submenu dla aktualnej pozycji menu głównego
     */
    public $submenu = '';
    /**
     *
     * @var string zmienna, pod którą znajduje się wygenerowany adres url
     */
    public $url;

    /*   * language
     *
     * @var array tablica opcji dla danego elementu menu
     */
    public $options;
    /**
     *
     * @var string klasa htmlowa danej pozycji menu
     */
    public $class;
    /**
     *
     * @var string wygenerowany pojedynczy link menu
     */
    public $link;
    /**
     *
     * @var string wyświetlana nazwa pojedynczego linku menu
     */
    public $linkName;
    /**
     *
     * @var string nazwa indeksu elementu generatorArray, pod którym są zdefiniowane wszystkie elementy danego menu
     */
    public $menuName = 'menu';
    public $linkYamlName = '';
    protected $request;
    protected $actionName;
    protected $moduleName;
    public $submenuSlot = '';
    public $activeLinkInSubmenu = array();

    /**
     * funkcja statyczna generująca całe menu, dzięki temu nie trzeba znać innych funkcji w generatorze
     *
     * @param type $yamlOrArray nazwa pliku .yml z menu lub tablica wartości
     * @return string zwraca kod html całego wygenerowanego menu
     */
    public static function getMenu($yamlOrArray)
    {
        $className = get_called_class();
        $menuGenerator = new $className();

        $menuGenerator->loadYamlOrArray($yamlOrArray);

        return $menuGenerator->generateFullMenu();
    }

    /**
     * funkcja ładuje tablice menu z pliku yaml
     * @param string $yamlName nazwa pliku yaml (razem z rozszerzeniem)
     */
    public function loadYamlFile($yamlName)
    {
        $this->generatorArray = sfYaml::load(sfConfig::get('sf_app_lib_dir') . '/' . $yamlName . '.yml');
        $this->generatorArray['settings']['menu_partial_name'] = $yamlName;
        $this->setVars();
    }

    /**
     * funkcja ładuje tablice menu z tablicy zadeklarowanej ręcznie
     * @param array $array tablica z całym menu
     */
    public function loadMenuArray($array)
    {
        $this->generatorArray = $array;
        $this->setVars();
    }

    public function loadYamlOrArray($yamlOrArray)
    {
        if (is_array($yamlOrArray))
            $this->loadMenuArray($yamlOrArray);
        else
            $this->loadYamlFile($yamlOrArray);
    }

    /**
     *
     * @param type $menuName nazwa menu/submenu
     */
    public function __construct($menuName = 'menu')
    {
        $this->menuName = $menuName;
        $context = sfContext::getInstance();
        $this->request = $context->getRequest();
        $this->actionName = $context->getActionName();
        $this->moduleName = $context->getModuleName();
    }

    /**
     * funkcja ustawia wszystkie zmienne początkowe generatora.
     * Przygotowana dla nadpisania niektórych parametrów i wywołania dodatkowych metod w klasach dziedziczących
     */
    public function setVars()
    {
        $this->setArrays();
    }

    /**
     * funkcja ustawia odpowiednie tablice generatora z podanego pliku .yml bądź tablicy wartości
     */
    protected function setArrays()
    {
        foreach (array('settings', $this->menuName) as $i => $value)
            if (!isset($this->generatorArray[$value]))
                $this->generatorArray[$value] = array();

        $this->globalSettings = array_merge($this->getDefaultSettings(), $this->generatorArray['settings']);
        $this->menu = $this->generatorArray[$this->menuName];
        unset($this->generatorArray[$this->menuName]);

        if (isset($this->globalSettings['class_menu']) && isset($this->globalSettings['around_menu']['tags'])) {
            $aroundMenuKeys = array_keys($this->globalSettings['around_menu']['tags']);

            if (isset($this->globalSettings['around_menu']['tags'][current($aroundMenuKeys)]['class'])) {
                if ($this->globalSettings['around_menu']['tags'][current($aroundMenuKeys)]['class'] != $this->globalSettings['class_menu'])
                    $this->globalSettings['around_menu']['tags'][current($aroundMenuKeys)]['class'] .= ' ' . $this->globalSettings['class_menu'];
            } else
                $this->globalSettings['around_menu']['tags'][current($aroundMenuKeys)]['class'] = $this->globalSettings['class_menu'];
        }
    }

    /**
     * ustawia tablicę opcji dla konkretnego elemenu menu
     * @param type $options tablica opcji html dla konkretnego elementu menu
     */
    public function setOptions($options)
    {
        $this->options = array_merge($this->getDefaultOptions(), $options);
        $this->settings = array_merge($this->globalSettings, $this->options['settings']);

        $userLang = $this->getUserLang();
        $langOptions = $this->options['lang_options'];

        if (isset($langOptions[$userLang])) {
            if (isset($langOptions[$userLang]['settings']))
                $this->settings = array_merge($this->settings, $langOptions[$userLang]['settings']);
            $this->options = array_merge($this->options, $langOptions[$userLang]);
        }

        unset($this->options['lang_options']);
        unset($this->options['settings']);
    }

    /**
     * ustawia nazwę elementu menu
     * @param string $name nazwa elementu menu
     */
    public function setLinkName($name)
    {
        if ($this->options['display_name']) {
            $name = str_replace("\'", "'", $name);

            if ($this->settings['links_with_icon'])
                $this->linkName = '<span class="menu-link-icon"></span><span class="menu-link-text">' . __($name) . '</span>';
            else
                $this->linkName = __($name);

            if ($this->options['count_model'] != '') {
                $model = $this->options['count_model'];
                $method = $this->options['count_method'];
                $this->linkName .= $this->options['count_prefix'] . '[?php echo Doctrine::getTable(\'' . $model . '\')->' . $method . '() ?]' . $this->options['count_suffix'];
            }
        } else
            $this->linkName = ' ';
    }

    /**
     * funkcja budująca url dla konkretnej pozycji menu
     */
    public function buildUrl()
    {
        if (isset($this->options['link_across_app'])) {
            $isDevEnvironment = sfConfig::get('sf_environment') == 'dev';

            if (sfConfig::get('sf_app') == 'backend')
                $prefix = $isDevEnvironment ? '/frontend_dev.php' : '';
            else
                $prefix = $isDevEnvironment ? '/backend_dev.php' : '/backend.php';

            $this->url = $prefix . $this->options['link_across_app'];
        } else if (isset($this->options['url'])) {
            if (!isset($this->options['filter_from_link']))
                $this->url = url_for($this->options['url']);
            else {
                if (is_null($this->options['filter_from_link']) || $this->options['filter_from_link'] == '')
                    $this->options['filter_from_link'] = ' ';

                $this->url = url_for('@' . $this->options['url'] . '_link_filter?param=' . $this->options['filter_from_link']);
            }
        } else if (isset($this->options['url_at']))
            $this->url = url_for('@' . $this->options['url_at']);
        else if (isset($this->options['link']))
            $this->url = $this->options['link'];
        else // if ($this->options['url_is_hash'])
        {
            $this->url = $this->getHashReplacer();
            $this->options['url_is_hash'] = true;
        }
    }

    /**
     * funkcja ustawiająca aktywną klasę html dla aktywnej strony
     */
    public function setActiveClass()
    {
        if ($this->isActiveClass()) {
            $this->class .= $this->settings['class_active'] . ' ';
            $this->setActiveLinkInSubmenu($this->menuName, true);
        } else
            $this->class .= $this->settings['class_inactive'] . ' ';
    }

    /**
     * funkcja sprawdzająca czy dany element menu powinien mieć ustawioną aktywną klasę
     * @return bool zwraca true jeżeli dany element menu jest aktywnym elementem
     */
    public function isActiveClass()
    {
        if ($this->options['module'] != '') {
            if ($this->options['module'] != $this->moduleName)
                return false;
            else {
                if (in_array($this->actionName, $this->options['except_actions']))
                    return false;
                else if (!empty($this->options['actions']) && !in_array($this->actionName, $this->options['actions']))
                    return false;
            }
        }

        foreach ($this->options['request_params'] as $param => $values)
            if (!($this->request->hasParameter($param) && in_array($this->request->getParameter($param), $values)))
                return false;

        foreach ($this->options['except_request_params'] as $param => $values)
            if ($this->request->hasParameter($param))
                if (empty($values) || in_array($this->request->getParameter($param), $values))
                    return false;

        if (!empty($this->options['session_params'])) {
            foreach ($this->options['session_params'] as $param => $value)
                if ($this->getUser()->getAttribute($param, null) != $value && $this->getUser()->getFlash($param, null) != $value)
                    return false;

            return true;
        }

        if ($this->options['filter_from_link'] != '') {
            $url = url_for($this->options['url']);
            $canBeActiveLink = strpos($_SERVER["REQUEST_URI"], $url) !== false && $this->options['can_be_active_link'];
            $sessionFilterParam = $this->getUser()->getAttribute('filterParam', ' ', $this->options['url']);

            return $canBeActiveLink && $sessionFilterParam == $this->options['filter_from_link'];
        }

        return strpos($_SERVER["REQUEST_URI"], $this->url) !== false && $this->options['can_be_active_link'];
    }

    /**
     * funkcja budująca klasę danego elementu
     * @return string zwraca klasę htmlową danego elementu
     */
    public function buildClass()
    {
        $linkClass = $this->menuName . '-' . str_replace(' ', '-', sfInflector::underscore(str_replace(array("'"), '', slug::slugify($this->linkYamlName))));
        $this->class = $this->settings['class_all_links'] . ' ' . $linkClass . ' ' . $linkClass . '-' . $this->getUserLang() . ' ';

        $this->setActiveClass();

        if (!isset($this->options['options']['class']))
            $this->options['options']['class'] = $this->class;
        else
            $this->options['options']['class'] = $this->class . $this->options['options']['class'];

        return $this->options['options']['class'];
    }

    public function setActiveLinkInSubmenu($submenu, $value)
    {
        $this->activeLinkInSubmenu[$submenu] = $value;
    }

    /**
     * funkcja tworzy element menu (razem z wszystkimi opcjami, tagami itp)
     */
    public function createLink()
    {
        $settingsOutside = $this->settings['outside_link'];
        $settingsInside = $this->settings['inside_link'];

        if (isset($this->options['submenu']))
            MenuHelper::$activeClass = '[?php if(isset($menuGenerator-]activeLinkInSubmenu[\'' . $this->options['submenu'] . '\'])) echo \'' . $this->settings['class_active_in_submenu'] . '\'; ?]';

        $outside['beginInsideBoxTags'] = MenuHelper::createInsideArtBoxTags($settingsOutside);
        $outside['endInsideBoxTags'] = MenuHelper::createInsideArtBoxEndTags($settingsOutside);
        $outside['beginTag'] = MenuHelper::createSettingsBeginTag($settingsOutside);
        $outside['beginBox'] = MenuHelper::createBeginArtBox($settingsOutside);
        $outside['endTag'] = MenuHelper::createSettingsEndTag($settingsOutside);
        $outside['endBox'] = MenuHelper::createEndArtBox($settingsOutside);

        $inside['beginInsideBoxTags'] = MenuHelper::createInsideArtBoxTags($settingsInside);
        $inside['endInsideBoxTags'] = MenuHelper::createInsideArtBoxEndTags($settingsInside);
        $inside['beginTag'] = MenuHelper::createSettingsBeginTag($settingsInside);
        $inside['beginBox'] = MenuHelper::createBeginArtBox($settingsInside);
        $inside['endTag'] = MenuHelper::createSettingsEndTag($settingsInside);
        $inside['endBox'] = MenuHelper::createEndArtBox($settingsInside);

        $this->createLinkOutside($inside, $outside);
    }

    /**
     * funkcja buduje "otoczkę" linku
     * @param array $inside tablica ustawień w środku linku
     * @param array $outside tablica ustawień na zewnątrz linku
     */
    public function createLinkOutside($inside, $outside)
    {
        $this->link = $this->submenuSlot . $outside['beginTag'] . $outside['beginBox'] . $outside['beginInsideBoxTags'];

        $this->createLinkInside($inside);

//    $this->link .= $this->submenu . $outside['endInsideBoxTags'] . $outside['endBox'] . $outside['endTag'];
        $this->link .= $this->submenu . $outside['endInsideBoxTags'] . $outside['endBox'] . $outside['endTag'];
    }

    /**
     * funkcja buduje tagi i artBoxy w środku linku
     * @param array $inside tablica ustawień w środku linku
     */
    public function createLinkInside($inside)
    {
        $insideLink = $inside['beginTag'] . $inside['beginBox'] . $inside['beginInsideBoxTags'] . $this->linkName . $inside['endInsideBoxTags'] . $inside['endBox'] . $inside['endTag'];

        if (!$this->options['has_a'])
            $this->link .= $insideLink;
        else {
            $this->options['options']['class'] = '[?php $menuGenerator-]setArraysForPartial(' . $this->createStringPHPArrays() . '); echo $menuGenerator-]buildClass(); ?]';

            $this->link .= link_to1($insideLink, $this->url, $this->options['options']);

            if ($this->options['url_is_hash'])
                $this->setUrlIfHash();
        }
    }

    /**
     * funkcja ustawia a href na hash w przypadku włączenia odpowiedniej opcji
     */
    public function setUrlIfHash()
    {
        $this->link = str_replace($this->getHashReplacer(), '#', $this->link);
    }

    /**
     * funkcja generująca cały kod html menu
     * @return string cały kod html menu
     */
    public function generateFullMenu($menuPartialVars = array())
    {
        $partialName = $this->getMenuPartialName();
        $getFromCache = $this->globalSettings['cache'];

        try {
            if ($getFromCache)
                $fullMenu = $this->getPartial($partialName, $menuPartialVars);
        } catch (Exception $e) {
            $getFromCache = false;
        }

        if (!$getFromCache) {
            $settings = $this->globalSettings['around_menu'];

            $fullMenu = MenuHelper::createSettingsBeginTag($settings);
            $fullMenu .= MenuHelper::createBeginArtBox($settings);
            $fullMenu .= MenuHelper::createInsideArtBoxTags($settings);

            $fullMenu .= $this->generateLinks();

            $fullMenu .= MenuHelper::createInsideArtBoxEndTags($settings);
            $fullMenu .= MenuHelper::createEndArtBox($settings);
            $fullMenu .= MenuHelper::createSettingsEndTag($settings);

            if ($this->globalSettings['create_partial'])
                $fullMenu = $this->createPartial($partialName, $fullMenu, $menuPartialVars);
        }

        return $fullMenu;
    }

    /**
     * funkcja generująca wszystkie linki menu
     * @return string wszystkie linki menu
     */
    public function generateLinks()
    {
        $links = '';

        foreach ($this->menu as $name => $options) {
            $this->setOptions($options);
            $this->linkYamlName = $name;
            $this->setLinkName($name);

            if ($this->userHasPermission() && $this->isAppropriateEnvironment()) //&& $this->checkCondition()
            {
                if ($this->globalSettings['with_spacer'] && $links != '')
                    $links .= MenuHelper::getTag($this->globalSettings['spacer']);

                $this->generateSubmenu();
                $this->buildUrl();
                $this->createLink();

                if (isset($this->options['permission'])) {
                    if (is_array($this->options['permission'])) {
                        $permissionStr = "OldMenuGenerator::userHasPermissionCheckArray(\"" . implode(",", $this->options['permission']) . "\")";
                    } else {
                        $permissionStr = "OldMenuGenerator::userHasPermissionCheckString(\"" . $this->options['permission'] . "\")";
                    }

                    $links .= " \n[?php if (" . $permissionStr . ")\n{ ?] \n";
                }

                if (isset($this->options['condition']))
                    $links .= " \n[?php if (" . $this->options['condition'] . ")\n{ ?] \n";

                $links .= $this->link;

                if (isset($this->options['condition']))
                    $links .= " [?php } ?] \n\n";

                if (isset($this->options['permission']))
                    $links .= " [?php } ?] \n\n";

            }
        }

        return $links;
    }

    /**
     * generuje kod html submenu (jeżeli submenu istnieje, w przeciwnym wypadku nie robi nic)
     */
    public function generateSubmenu()
    {
        $this->submenuSlot = '';
        $this->submenu = '';

        if (isset($this->options['submenu'])) {
            $slotName = $this->options['submenu'] . '-link';
            $className = $this->settings['submenu_generator_class'];
            $submenuGenerator = new $className($this->options['submenu']);
            $submenuGenerator->loadMenuArray($this->generatorArray);
            $this->submenuSlot = "\n[?php slot('$slotName')?]\n\n";
            $this->submenuSlot .= $submenuGenerator->generateFullMenu() . "\n[?php end_slot('$slotName') ?]\n\n\n";
            $this->submenu = " \n[?php include_slot('$slotName') ?] \n\n";
//      $this->options['url_is_hash'] = true;
        }
    }

    /**
     * funkcja sprawdza czy użytkownik ma pozwolenie do wyświetlenia danego elementu menu
     * @return bool zwraca true jeżeli użytkownik ma pozwolenie
     */
    public function userHasPermission()
    {
        if (isset($this->options['is_authenticated']))
            return $this->getUser()->isAuthenticated() == $this->options['is_authenticated'];

        if (isset($this->options['permission'])) {
            $permissions = $this->getUser()->getPermissionNames();

            if (!is_array($this->options['permission']))
                return in_array($this->options['permission'], $permissions);

            foreach ($this->options['permission'] as $permission)
                if (in_array($permission, $permissions))
                    return true;

            return false;
        }

        return true;
    }

    public static function userHasPermissionCheckArray($permissionsStr)
    {
        $permissions = explode(',', $permissionsStr);
        $userPermissions = sfContext::getInstance()->getUser()->getPermissionNames();

        foreach ($permissions as $permission)
            if (in_array($permission, $userPermissions))
                return true;

        return false;
    }

    public static function userHasPermissionCheckString($str)
    {
        $userPermissions = sfContext::getInstance()->getUser()->getPermissionNames();

        return in_array($str, $userPermissions);
    }

    public function isAppropriateEnvironment()
    {
        if ($this->options['only_dev'])
            return sfConfig::get('sf_environment') == 'dev';
        else
            return true;
    }

    public function checkCondition()
    {
        if (isset($this->options['condition'])) {
            $conditionString = '$condition = ' . $this->options['condition'] . ';';
            eval($conditionString);

            return $condition;
        }

        return true;
    }

}