<?php

/**
 * PluginArtConfiguration
 *
 * This class has been auto-generated by the Doctrine ORM Framework
 *
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginArtConfiguration extends BaseArtConfiguration {

  public static $namePrefix = '__';

  /**
   * Ładuje konfigurację.
   */
  public static function loadConfiguration() {
    if (!sfConfig::get('app_art_configuration_load', true))
      return;

    $configs = Doctrine::getTable('ArtConfiguration')->getAllInArray();

    foreach ($configs as $config) {
      foreach ($config['Translation'] as $key => $translations) {
        sfConfig::set(self::$namePrefix . $key . '_' . $config['name'], $translations['value']);
      }
    }
  }

  /**
   * Pobiera wartośc zmiennej z konfiguracji.
   *
   * @param $name
   * @param null $default
   * @return mixed
   */
  public static function getConfig($name, $default = null) {

    $value = sfConfig::get(self::$namePrefix . $name, $default);

    // Sproboj pobrac tanslacyjne jesli nic nie znalazl
    if (is_null($value) || $value == $default) {
      $culture = sfContext::getInstance()->getUser()->getCulture();
      $value = sfConfig::get(self::$namePrefix . $culture . '_' . $name, $default);
    }

    return ($value != '') ? $value : $default;
  }

  /**
   * Ustawia zmienną konfiguracyjną.
   *
   * @param $name
   * @param $value
   */
  public static function setConfig($name, $value) {
    $object = Doctrine::getTable('ArtConfiguration')->findOneByName($name);
    $object->setValue($value);
    $object->save();

    sfConfig::set(self::$namePrefix . $name, $value);
  }

  public function preInsert($event) {
    $object = $event->getInvoker();

    if (is_null($object->default))
      $object->default = $object->value;
  }

  public function getI18nName() {
    $name = __($this->getName());

    if (artSettings::isDevEnvironment() && $name !== $this->getName())
      return $name . ' (' . $this->getName() . ')';
    else
      return $name;
  }

  public function getListValue() {
    $renderer = $this->getRenderer() . '';

    if (is_null($renderer) || $renderer == '')
      return $this->getValue();
    else
      return $renderer($this->getValue());
  }

  public function getListDefault() {
    $renderer = $this->getRenderer() . '';

    if (is_null($renderer) || $renderer == '')
      return $this->getDefault();
    else
      return $renderer($this->getDefault());
  }

  public static function configurationTableExists() {
    $conn = Doctrine_Manager::connection();
    try {
      $conn->execute("DESC art_configuration");
    } catch (Exception $e) {
      return false;
    }
    return true;
  }

  public static function getMetaKeywords() {
    $ret = self::getConfig(sfContext::getInstance()->getUser()->getCulture() . '_meta_keywords');

    if ($ret == '')
      $ret = self::getConfig('pl_meta_keywords');

    return $ret;
  }

  public static function getMetaDescription() {
    $ret = self::getConfig('meta_description_' . sfContext::getInstance()->getUser()->getCulture());
    ;
    if ($ret == '')
      $ret = self::getConfig('pl_meta_description');
    return $ret;
  }

  public static function getGoogleMapsCode($prefix = false) {
    if ($prefix) {
      $ret = self::getConfig(sfContext::getInstance()->getUser()->getCulture() . '_' . $prefix . '_google_maps_code');

      if ($ret == '')
        return self::getConfig('pl_' . $prefix . '_google_maps_code');

      return $ret;
    } else {
      $ret = self::getConfig(sfContext::getInstance()->getUser()->getCulture() . '_google_maps_code');

      if ($ret == '')
        return self::getConfig('pl_google_maps_code');

      return $ret;
    }
  }

  public static function getGoogleAnalyticsCode() {
    $ret = self::getConfig(sfContext::getInstance()->getUser()->getCulture() . '_google_analytics_code');

    if ($ret == '')
      return self::getConfig('pl_google_analytics_code');

    return $ret;
  }

  public static function getMetaTitle() {
    $ret = self::getConfig(sfContext::getInstance()->getUser()->getCulture() . '_meta_title');
    ;
    if ($ret == '')
      $ret = self::getConfig('pl_meta_title');
    return $ret;
  }

  public static function setArticleMetaTags($article, $response) {

    if (!sfContext::getInstance()->getRequest()->isXmlHttpRequest()) {

      $metaKeywords = $article->getMetaKeywords();
      $metaDescription = $article->getMetaDescription();
      $metaTitle = $article->getMetaTitle();


      $configurationTableExists = static::configurationTableExists();

      if ($configurationTableExists) {
        $metaKeywordsFromArtConf = static::getMetaKeywords();
        $metaDescriptionFromArtConf = static::getMetaDescription();
        $metaTitleFromArtConf = static::getMetaTitle();
      }

      if (isset($metaKeywords) && $metaKeywords != '')
        $response->addMeta('keywords', $metaKeywords);
      elseif ($configurationTableExists && $metaKeywordsFromArtConf != '' && !is_null($metaKeywordsFromArtConf))
        $response->addMeta('keywords', $metaKeywordsFromArtConf);

      if (isset($metaDescription) && $metaDescription != '')
        $response->addMeta('description', $metaDescription);
      elseif ($configurationTableExists && $metaDescriptionFromArtConf != '' && !is_null($metaDescriptionFromArtConf))
        $response->addMeta('description', $metaDescriptionFromArtConf);

      if (isset($metaTitle) && $metaTitle != '')
        $response->setTitle($metaTitle);
      elseif ($configurationTableExists && $metaTitleFromArtConf != '' && !is_null($metaTitleFromArtConf))
        $response->setTitle($metaTitleFromArtConf);

      return $response;
    }
  }
  
  public static function getSocials() {
    $socialNames = array(
      'social_facebook' => 'megaicon1-social-facebook',
      'social_twitter' => 'megaicon1-twitter-alt',
      'social_googleplus' => 'megaicon1-social-google-plus',
      'social_youtube' => 'megaicon1-social-youtube',
      'social_behance' => 'megaicon1-social-behance',
      'social_vimeo' => 'megaicon1-social-vimeo',
      'social_pinterest' => 'megaicon1-social-pinterest',
    );
    
    $socials = array();
    $culture = sfContext::getInstance()->getUser()->getCulture();
    foreach ($socialNames as $name => $icon) {
      $value = self::getConfig($culture . '_' . $name, null);
      if (!is_null($value) && $value != '') {
        $socials[$icon] = $value;
      }
    }
    
    return $socials;
  }

  public static function getMetaRobots() {
    return self::getConfig(sfContext::getInstance()->getUser()->getCulture() . '_meta_robots', 'noindex');
  }

  public static function getHost() {
    $culture = sfConfig::get('sf_default_culture');
    return sfConfig::get(self::$namePrefix . $culture . '_host', 'symfony');
  }

  public static function getSitemapEnabled() {
    $culture = sfConfig::get('sf_default_culture');
    return sfConfig::get(self::$namePrefix . $culture . '_sitemap_enabled', false);
  }

  public static function getSitemapFilename() {
    $culture = sfConfig::get('sf_default_culture');
    return sfConfig::get(self::$namePrefix . $culture . '_sitemap_filename', 'sitemap.xml');
  }
  
  public static function getArtCmsArticleTitleImageWidth() {
    $conf = sfConfig::get('app_art_cms_plugin_article');
    
    $value = 500;
    if (isset($conf['title_image']['width'])) {
      $value = $conf['title_image']['width'];
    }
    
    return $value;
  }
  public static function getArtCmsArticleTitleImageHeight() {
    $conf = sfConfig::get('app_art_cms_plugin_article');
    
    $value = 500;
    if (isset($conf['title_image']['height'])) {
      $value = $conf['title_image']['height'];
    }
    
    return $value;
  }
  
  public function __toString() {
    return $this->getLabel();
  }

}
